/*
 * Decompiled with CFR 0.152.
 */
package lambda.system;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lambda.system.CommandDelegate;

public class CommandProcessor {
    private Map<String, CommandDelegate> delegates = new HashMap<String, CommandDelegate>();

    public void add(String command, CommandDelegate d) {
        this.delegates.put(command, d);
    }

    public void invokeCommand(String input) {
        String[] args = input.split("\\s+");
        String cmd = args[0];
        CommandDelegate l = this.delegates.get(cmd);
        if (l != null) {
            String[] params = Arrays.copyOfRange(args, 1, args.length);
            l.commandInvoked(params);
        } else {
            System.out.println("- unknown command " + cmd);
        }
    }

    public boolean invokeCommand(String cmd, String ... params) {
        CommandDelegate l = this.delegates.get(cmd);
        if (l != null) {
            l.commandInvoked(params);
            return true;
        }
        return false;
    }
}

