/*
 * Decompiled with CFR 0.152.
 */
package lambda.serialize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import lambda.ast.parser.ParserException;

public class LambdaSerializer {
    private static SerializeVisitor visitor;

    private LambdaSerializer() {
    }

    public static short[] serialize(Lambda lambda) {
        if (visitor == null) {
            visitor = new SerializeVisitor();
        }
        ArrayList data = new ArrayList();
        visitor.initialize();
        lambda.accept(visitor, data);
        short[] a = new short[data.size()];
        int i = 0;
        while (i < a.length) {
            a[i] = (Short)data.get(i);
            ++i;
        }
        return a;
    }

    public static void main(String[] args) {
        System.out.println("SerializeTest");
        Scanner sc = new Scanner(System.in);
        while (true) {
            System.out.print("input> ");
            String s = sc.nextLine();
            if (s == null || (s = s.trim()).isEmpty()) break;
            try {
                Lambda e = Lambda.parse(s);
                System.out.println("e = " + e);
                System.out.println("data: " + Arrays.toString(LambdaSerializer.serialize(e)));
            }
            catch (ParserException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private static class SerializeVisitor
    implements Lambda.VisitorRP<Object, List<Short>> {
        private static final short LAMBDA_BEGIN = 32766;
        private static final short LAMBDA_END = Short.MAX_VALUE;
        private Context cl = new Context();
        private Map<String, Short> fv = new HashMap<String, Short>();
        private short fvId = 1;

        private SerializeVisitor() {
        }

        public void initialize() {
            this.cl.clear();
            this.fv.clear();
            this.fvId = 1;
        }

        @Override
        public Object visit(ASTAbstract abs, List<Short> data) {
            this.cl.pushVariable(abs.name);
            data.add((short)32766);
            abs.e.accept(this, data);
            data.add((short)Short.MAX_VALUE);
            this.cl.popVariable();
            return null;
        }

        @Override
        public Object visit(ASTApply app, List<Short> data) {
            app.lexpr.accept(this, data);
            app.rexpr.accept(this, data);
            return null;
        }

        @Override
        public Object visit(ASTLiteral l, List<Short> data) {
            data.add(this.getId(this.cl, l.name));
            return null;
        }

        @Override
        public Object visit(ASTMacro m, List<Short> data) {
            data.add(this.getFreeVariableId(m.name));
            return null;
        }

        private short getId(Context c, String name) {
            short id = c.findVariable(name);
            if (id != -1) {
                return id;
            }
            return this.getFreeVariableId(name);
        }

        private short getFreeVariableId(String name) {
            Short id = this.fv.get(name);
            if (id == null) {
                short s = this.fvId;
                this.fvId = (short)(s + 1);
                id = -s;
                this.fv.put(name, id);
            }
            return id;
        }

        private static class Context {
            private LinkedList<String> names = new LinkedList();

            private Context() {
            }

            public void clear() {
                this.names.clear();
            }

            public void pushVariable(String name) {
                this.names.push(name);
            }

            public void popVariable() {
                this.names.pop();
            }

            public short findVariable(String name) {
                Iterator it = this.names.iterator();
                int i = 0;
                while (it.hasNext()) {
                    if (((String)it.next()).equals(name)) {
                        return (short)(i + 1);
                    }
                    i = (short)(i + 1);
                }
                return -1;
            }
        }
    }
}

