/*
 * Decompiled with CFR 0.152.
 */
package lambda.reductiongraph.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import lambda.ast.Lambda;
import lambda.gui.util.GUIUtils;
import lambda.reductiongraph.StateSearcher;
import lambda.reductiongraph.event.SearchEndListener;
import lambda.reductiongraph.gui.DirectedGraphPanel;

public class ReductionGraphView
extends JPanel {
    private DirectedGraphPanel graphPanel;
    private JButton buttonStart;
    private JButton buttonStop;
    private JSpinner spinnerMaxDepth;
    private StateSearcher searcher;
    private int storedNodeCount;

    public ReductionGraphView() {
        this.setLayout(new BorderLayout());
        this.graphPanel = new DirectedGraphPanel();
        this.add((Component)this.graphPanel, "Center");
        this.buttonStart = new JButton("start");
        this.buttonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReductionGraphView.this.dispathActionEvent();
            }
        });
        this.buttonStop = new JButton("stop");
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReductionGraphView.this.searcher != null) {
                    ReductionGraphView.this.searcher.abort();
                }
            }
        });
        this.buttonStop.setEnabled(false);
        this.spinnerMaxDepth = new JSpinner(new SpinnerNumberModel(20, 1, 100, 1));
        final JCheckBox checkAntialias = new JCheckBox("antialias");
        checkAntialias.setSelected(false);
        checkAntialias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReductionGraphView.this.graphPanel.setAntialias(checkAntialias.isSelected());
            }
        });
        final JCheckBox checkCurve = new JCheckBox("curve");
        checkCurve.setSelected(true);
        checkCurve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReductionGraphView.this.graphPanel.setDrawCurve(checkCurve.isSelected());
            }
        });
        final JCheckBox checkMultiEdge = new JCheckBox("multi-edge");
        checkMultiEdge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReductionGraphView.this.graphPanel.setMultipleEdges(checkMultiEdge.isSelected());
            }
        });
        JPanel p1 = new JPanel();
        p1.add(this.buttonStart);
        p1.add(this.buttonStop);
        p1.add(new JLabel("max depth:"));
        p1.add(this.spinnerMaxDepth);
        JPanel p2 = new JPanel();
        p2.add(checkAntialias);
        p2.add(checkCurve);
        p2.add(checkMultiEdge);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(p1);
        buttonPanel.add(p2);
        GUIUtils.setVerticalLayout(buttonPanel, false, false);
        this.add((Component)buttonPanel, "South");
    }

    public int getStoredNodeCount() {
        return this.storedNodeCount;
    }

    public void setStartButtonEnabled(boolean b) {
        this.buttonStart.setEnabled(b);
    }

    public void setStopButtonEnabled(boolean b) {
        this.buttonStop.setEnabled(b);
    }

    public void startSearch(Lambda lambda) {
        this.buttonStart.setEnabled(false);
        this.buttonStop.setEnabled(true);
        this.graphPanel.clearGraph();
        int maxDepth = (Integer)this.spinnerMaxDepth.getValue();
        this.searcher = new StateSearcher(this.graphPanel, lambda, maxDepth);
        this.searcher.addSearchEndListener(new SearchEndListener(){

            @Override
            public void searchEnded() {
                ReductionGraphView.this.storedNodeCount = ReductionGraphView.this.searcher.getStateCount();
                ReductionGraphView.this.dispathSearchEndEvent();
                ReductionGraphView.this.buttonStart.setEnabled(true);
                ReductionGraphView.this.buttonStop.setEnabled(false);
                ReductionGraphView.this.searcher = null;
            }
        });
        this.searcher.startSearch();
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void dispathActionEvent() {
        ActionEvent event = new ActionEvent(this, 0, "start");
        ActionListener[] actionListenerArray = (ActionListener[])this.listenerList.getListeners(ActionListener.class);
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener l = actionListenerArray[n2];
            l.actionPerformed(event);
            ++n2;
        }
    }

    public void addSearchEndListener(SearchEndListener l) {
        this.listenerList.add(SearchEndListener.class, l);
    }

    public void removeSearchEndListener(SearchEndListener l) {
        this.listenerList.remove(SearchEndListener.class, l);
    }

    private void dispathSearchEndEvent() {
        SearchEndListener[] searchEndListenerArray = (SearchEndListener[])this.listenerList.getListeners(SearchEndListener.class);
        int n = searchEndListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchEndListener l = searchEndListenerArray[n2];
            l.searchEnded();
            ++n2;
        }
    }
}

