/*
 * Decompiled with CFR 0.152.
 */
package lambda.reductiongraph.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import lambda.reductiongraph.gui.Edge;
import lambda.reductiongraph.gui.GraphNode;
import lambda.reductiongraph.gui.Multiset;

public class DirectedGraphPanel
extends JPanel {
    private static final Color TEXT_BACK_COLOR = new Color(255, 255, 255, 220);
    private static final Stroke LINE_STROKE = new BasicStroke(0.5f, 0, 2);
    private static final Stroke EM_LINE_STROKE = new BasicStroke(1.0f, 0, 2);
    private final Object lockEdges = new Object();
    private GraphNode initialNode;
    private GraphNode hoverNode;
    private List<GraphNode> nodes = new LinkedList<GraphNode>();
    private Map<Integer, Set<GraphNode>> depthSlicedNodes = new HashMap<Integer, Set<GraphNode>>();
    private int maxDepth;
    private Map<GraphNode, Multiset<GraphNode>> edges = new HashMap<GraphNode, Multiset<GraphNode>>();
    private List<Edge> edgeLines = new ArrayList<Edge>();
    private List<Edge> inEdgeLines = new ArrayList<Edge>();
    private List<Edge> outEdgeLines = new ArrayList<Edge>();
    private boolean structureChanged;
    private boolean hoverNodeChanged;
    private boolean resized;
    private Point translation = new Point();
    private boolean antialias;
    private boolean drawCurve;
    private boolean multipleEdges;
    private boolean animationSuspended;
    private double scale = 1.0;

    public DirectedGraphPanel() {
        MouseAdapter m = new MouseAdapter(){
            private Point mp;

            @Override
            public void mousePressed(MouseEvent e) {
                this.mp = e.getPoint();
                DirectedGraphPanel.this.requestFocus();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                DirectedGraphPanel.this.updateHoverNode(e.getX() - ((DirectedGraphPanel)DirectedGraphPanel.this).translation.x, e.getY() - ((DirectedGraphPanel)DirectedGraphPanel.this).translation.y);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int dx = e.getX() - this.mp.x;
                int dy = e.getY() - this.mp.y;
                this.mp = e.getPoint();
                ((DirectedGraphPanel)DirectedGraphPanel.this).translation.x += dx;
                ((DirectedGraphPanel)DirectedGraphPanel.this).translation.y += dy;
                DirectedGraphPanel.this.resumeAnimation();
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int r = e.getWheelRotation();
                if (r >= 0) {
                    DirectedGraphPanel directedGraphPanel = DirectedGraphPanel.this;
                    directedGraphPanel.scale = directedGraphPanel.scale * 0.9;
                } else {
                    DirectedGraphPanel directedGraphPanel = DirectedGraphPanel.this;
                    directedGraphPanel.scale = directedGraphPanel.scale * 1.1;
                }
                DirectedGraphPanel.this.resized = true;
                DirectedGraphPanel.this.resumeAnimation();
            }
        };
        this.addMouseListener(m);
        this.addMouseMotionListener(m);
        this.addMouseWheelListener(m);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DirectedGraphPanel.this.resized = true;
                DirectedGraphPanel.this.resumeAnimation();
            }
        });
        this.setFocusable(true);
        this.setIgnoreRepaint(true);
        this.setDrawCurve(true);
        this.setupAccelerators();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        if (DirectedGraphPanel.this.animationSuspended) {
                            DirectedGraphPanel.this.suspendAnimation();
                        }
                        DirectedGraphPanel.this.updateFrame();
                        DirectedGraphPanel.this.repaint();
                        Thread.sleep(20L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        };
        thread.setName("AnimationThread");
        thread.setDaemon(true);
        thread.start();
    }

    public void setAntialias(boolean b) {
        this.antialias = b;
        this.resumeAnimation();
    }

    public void setDrawCurve(boolean b) {
        this.drawCurve = b;
        this.resumeAnimation();
    }

    public void setMultipleEdges(boolean b) {
        this.multipleEdges = b;
        this.resumeAnimation();
    }

    private void setupAccelerators() {
        int mod = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        InputMap im = this.getInputMap(0);
        im.put(KeyStroke.getKeyStroke(45, mod), "min");
        im.put(KeyStroke.getKeyStroke(109, mod), "min");
        im.put(KeyStroke.getKeyStroke(107, mod), "mag");
        im.put(KeyStroke.getKeyStroke(521, mod), "mag");
        im.put(KeyStroke.getKeyStroke(59, mod), "mag");
        im.put(KeyStroke.getKeyStroke(48, mod), "reset");
        ActionMap am = this.getActionMap();
        am.put("min", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectedGraphPanel.this.minifyNodeSize();
            }
        });
        am.put("mag", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectedGraphPanel.this.magnifyNodeSize();
            }
        });
        am.put("reset", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectedGraphPanel.this.resetAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendAnimation() {
        try {
            DirectedGraphPanel directedGraphPanel = this;
            synchronized (directedGraphPanel) {
                while (this.animationSuspended) {
                    this.notifyAll();
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeAnimation() {
        DirectedGraphPanel directedGraphPanel = this;
        synchronized (directedGraphPanel) {
            this.animationSuspended = false;
            this.notifyAll();
        }
    }

    public void magnifyNodeSize() {
        ++GraphNode.R;
        this.resumeAnimation();
    }

    public void minifyNodeSize() {
        GraphNode.R = Math.max(GraphNode.R - 1, 0);
        this.resumeAnimation();
    }

    public void resetAll() {
        GraphNode.R = 8;
        this.translation.setLocation(0, 0);
        this.scale = 1.0;
        this.resized = true;
        this.resumeAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(GraphNode node) {
        List<GraphNode> list = this.nodes;
        synchronized (list) {
            this.nodes.add(node);
            this.structureChanged = true;
        }
        this.resumeAnimation();
    }

    public void setInitialNode(GraphNode node) {
        this.initialNode = node;
        this.resumeAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEdge(GraphNode source, GraphNode sink) {
        Object object = this.lockEdges;
        synchronized (object) {
            Multiset<GraphNode> sinks = this.edges.get(source);
            if (sinks == null) {
                sinks = new Multiset();
                this.edges.put(source, sinks);
            }
            sinks.add(sink);
            this.structureChanged = true;
            this.resumeAnimation();
        }
    }

    public void addEdges(GraphNode source, GraphNode ... sinks) {
        GraphNode[] graphNodeArray = sinks;
        int n = sinks.length;
        int n2 = 0;
        while (n2 < n) {
            GraphNode sink = graphNodeArray[n2];
            this.addEdge(source, sink);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGraph() {
        Object object = this.nodes;
        synchronized (object) {
            this.nodes.clear();
        }
        this.setInitialNode(null);
        this.setHoverNode(null);
        object = this.lockEdges;
        synchronized (object) {
            this.edges.clear();
            this.edgeLines.clear();
            this.inEdgeLines.clear();
            this.outEdgeLines.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHoverNode(int x, int y) {
        GraphNode h = null;
        List<GraphNode> list = this.nodes;
        synchronized (list) {
            for (GraphNode n : this.nodes) {
                int ny;
                int nx = n.getX();
                if ((nx - x) * (nx - x) + ((ny = n.getY()) - y) * (ny - y) > GraphNode.R * GraphNode.R) continue;
                h = n;
                break;
            }
        }
        this.setHoverNode(h);
    }

    private synchronized void setHoverNode(GraphNode node) {
        if (this.hoverNode != node) {
            this.hoverNode = node;
            this.hoverNodeChanged = true;
            this.resumeAnimation();
        }
    }

    private synchronized GraphNode getHoverNode() {
        return this.hoverNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layoutNodes() {
        if (this.initialNode == null) {
            return;
        }
        this.depthSlicedNodes.clear();
        HashSet<GraphNode> visited = new HashSet<GraphNode>();
        LinkedList<GraphNode> queue = new LinkedList<GraphNode>();
        this.initialNode.setDepth(0);
        queue.add(this.initialNode);
        this.maxDepth = 0;
        while (!queue.isEmpty()) {
            GraphNode n1 = (GraphNode)queue.poll();
            if (visited.contains(n1)) continue;
            visited.add(n1);
            this.maxDepth = Math.max(n1.getDepth(), this.maxDepth);
            Set<GraphNode> set = this.depthSlicedNodes.get(n1.getDepth());
            if (set == null) {
                set = new HashSet<GraphNode>();
                this.depthSlicedNodes.put(n1.getDepth(), set);
            }
            set.add(n1);
            Object object = this.lockEdges;
            synchronized (object) {
                Multiset<GraphNode> nextNodes = this.edges.get(n1);
                if (nextNodes != null) {
                    for (GraphNode n2 : nextNodes.getKeySet()) {
                        if (visited.contains(n2)) continue;
                        n2.setDepth(Math.min(n2.getDepth(), n1.getDepth() + 1));
                        queue.add(n2);
                    }
                }
            }
        }
    }

    private void updateNodeLocation() {
        double width = this.scale * (double)this.getWidth();
        double height = this.scale * (double)this.getHeight();
        for (Map.Entry<Integer, Set<GraphNode>> e : this.depthSlicedNodes.entrySet()) {
            Set<GraphNode> set = e.getValue();
            int n = set.size();
            int i = 0;
            int depth = e.getKey();
            int y = (int)(((double)this.getHeight() - height) / 2.0 + height * (double)(depth + 1) / (double)(this.maxDepth + 2));
            for (GraphNode node : set) {
                int x = (int)(((double)this.getWidth() - width) / 2.0 + width * (double)(++i) / (double)(n + 1));
                node.setDestination(x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEdgeLines() {
        GraphNode hn = this.getHoverNode();
        Object object = this.lockEdges;
        synchronized (object) {
            this.edgeLines.clear();
            this.outEdgeLines.clear();
            this.inEdgeLines.clear();
            for (Map.Entry<GraphNode, Multiset<GraphNode>> e : this.edges.entrySet()) {
                GraphNode src = e.getKey();
                for (Map.Entry<GraphNode, Integer> entry : e.getValue()) {
                    GraphNode sink = entry.getKey();
                    int multiplicity = entry.getValue();
                    Edge edgeLine = new Edge(src, sink, multiplicity);
                    if (src == hn) {
                        this.outEdgeLines.add(edgeLine);
                        continue;
                    }
                    if (sink == hn) {
                        this.inEdgeLines.add(edgeLine);
                        continue;
                    }
                    this.edgeLines.add(edgeLine);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrame() {
        boolean animating = false;
        List<GraphNode> list = this.nodes;
        synchronized (list) {
            for (GraphNode n : this.nodes) {
                boolean bl = animating = n.update() || animating;
            }
        }
        if (this.structureChanged || this.resized) {
            this.layoutNodes();
        }
        this.updateNodeLocation();
        list = this.nodes;
        synchronized (list) {
            Collections.sort(this.nodes, NodeLocationComparator.getInstance());
        }
        if (this.hoverNodeChanged || this.structureChanged) {
            this.updateEdgeLines();
        }
        if (!(animating || this.structureChanged || this.hoverNodeChanged || this.resized)) {
            this.animationSuspended = true;
        }
        this.resized = false;
        this.structureChanged = false;
        this.hoverNodeChanged = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(Graphics2D g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int trX = this.translation.x;
        int trY = this.translation.y;
        g.translate(trX, trY);
        if (this.antialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setStroke(LINE_STROKE);
        Object object = this.lockEdges;
        synchronized (object) {
            g.setColor(Color.LIGHT_GRAY);
            this.drawEdges(g, this.edgeLines);
        }
        object = this.nodes;
        synchronized (object) {
            for (GraphNode n : this.nodes) {
                n.draw(g, n == this.initialNode);
            }
        }
        g.setStroke(EM_LINE_STROKE);
        object = this.lockEdges;
        synchronized (object) {
            g.setColor(Color.BLUE);
            this.drawEdges(g, this.inEdgeLines);
            g.setColor(Color.RED);
            this.drawEdges(g, this.outEdgeLines);
        }
        GraphNode hn = this.getHoverNode();
        if (hn != null) {
            g.setColor(TEXT_BACK_COLOR);
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(hn.getLabel());
            int h = fm.getHeight();
            g.fillRect(hn.getX() + 20, hn.getY() - 8 - h + fm.getDescent(), w, h);
            g.setColor(Color.BLACK);
            g.drawString(hn.getLabel(), hn.getX() + 20, hn.getY() - 8);
        }
        if (this.antialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
        g.translate(-trX, -trY);
        g.setColor(Color.GRAY);
        List<GraphNode> list = this.nodes;
        synchronized (list) {
            g.drawString("Nodes = " + this.nodes.size(), 5, 20);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.render((Graphics2D)g);
    }

    private void drawEdges(Graphics2D g, List<Edge> edges) {
        for (Edge edge : edges) {
            GraphNode p = edge.p;
            GraphNode q = edge.q;
            if (p == q) {
                DirectedGraphPanel.drawSelfCyclicEdge(g, p.getX(), p.getY());
                continue;
            }
            if (this.drawCurve) {
                int m = this.multipleEdges ? edge.multiplicity : 1;
                DirectedGraphPanel.drawCurveEdge(g, p.getX(), p.getY(), q.getX(), q.getY(), m);
                continue;
            }
            DirectedGraphPanel.drawStraightEdge(g, p.getX(), p.getY(), q.getX(), q.getY());
        }
    }

    private static void drawCurveEdge(Graphics2D g, int x0, int y0, int x1, int y1, int m) {
        double a = Math.atan2(y1 - y0, x1 - x0) - 1.5707963267948966;
        int r = GraphNode.R + 2;
        int i = 0;
        while (i < m) {
            int l = 30 * (i + 1);
            double cx = (double)(x0 + x1) / 2.0 + (double)l * Math.cos(a);
            double cy = (double)(y0 + y1) / 2.0 + (double)l * Math.sin(a);
            double as = Math.atan2(cy - (double)y0, cx - (double)x0);
            double at = Math.atan2((double)y1 - cy, (double)x1 - cx);
            double rcosAs = (double)r * Math.cos(as);
            double rsinAs = (double)r * Math.sin(as);
            double rcosAt = (double)r * Math.cos(at);
            double rsinAt = (double)r * Math.sin(at);
            double sX = (double)x0 + rcosAs;
            double sY = (double)y0 + rsinAs;
            double tX = (double)x1 - rcosAt;
            double tY = (double)y1 - rsinAt;
            QuadCurve2D.Double curve = new QuadCurve2D.Double(sX, sY, cx, cy, tX, tY);
            g.draw(curve);
            DirectedGraphPanel.drawTriangle(g, tX, tY, at);
            ++i;
        }
    }

    private static void drawStraightEdge(Graphics2D g, int x0, int y0, int x1, int y1) {
        double a = Math.atan2(y1 - y0, x1 - x0);
        double cosA = Math.cos(a);
        double sinA = Math.sin(a);
        double r = GraphNode.R + 2;
        double sX = (double)x0 + r * cosA;
        double sY = (double)y0 + r * sinA;
        double tX = (double)x1 - r * cosA;
        double tY = (double)y1 - r * sinA;
        g.drawLine((int)sX, (int)sY, (int)tX, (int)tY);
        DirectedGraphPanel.drawTriangle(g, tX, tY, a);
    }

    private static void drawSelfCyclicEdge(Graphics2D g, int x, int y) {
        int r = GraphNode.R + 2;
        double x1 = x;
        double y1 = y - r;
        double cx1 = x + 4 * r;
        double cy1 = y - 8 * r;
        double cx2 = x + 4 * r;
        double cy2 = y + 8 * r;
        double x2 = x;
        double y2 = y + r;
        CubicCurve2D.Double curve = new CubicCurve2D.Double(x1, y1, cx1, cy1, cx2, cy2, x2, y2);
        g.draw(curve);
        double a = Math.atan2(y2 - cy2, x2 - cx2);
        DirectedGraphPanel.drawTriangle(g, x, y + r, a);
    }

    private static void drawTriangle(Graphics g, double x, double y, double angle) {
        int size = 6;
        Polygon p = new Polygon();
        p.addPoint((int)x, (int)y);
        p.addPoint((int)(x - (double)size * Math.cos(angle + 0.5235987755982988)), (int)(y - (double)size * Math.sin(angle + 0.5235987755982988)));
        p.addPoint((int)(x - (double)size * Math.cos(angle - 0.5235987755982988)), (int)(y - (double)size * Math.sin(angle - 0.5235987755982988)));
        g.fillPolygon(p);
    }

    private static class NodeLocationComparator
    implements Comparator<GraphNode> {
        private static NodeLocationComparator instance;

        private NodeLocationComparator() {
        }

        @Override
        public int compare(GraphNode n1, GraphNode n2) {
            if (n1.getDepth() == n2.getDepth()) {
                return Double.compare(n1.getX(), n2.getX());
            }
            return n1.getDepth() < n2.getDepth() ? -1 : 1;
        }

        public static Comparator<GraphNode> getInstance() {
            return instance == null ? (instance = new NodeLocationComparator()) : instance;
        }
    }
}

