/*
 * Decompiled with CFR 0.152.
 */
package lambda.reductiongraph;

import java.util.Collections;
import java.util.List;
import lambda.Environment;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.reduction.RedexFinder;
import lambda.reductiongraph.IStateNode;
import lambda.serialize.LambdaSerializer;

public class LambdaNode
implements IStateNode {
    public final int depth;
    public final Lambda lambda;
    private String text;
    private short[] data;
    private List<IRedexNode> redexes;

    public LambdaNode(int depth, Lambda lambda) {
        this.depth = depth;
        this.lambda = lambda;
        this.data = LambdaSerializer.serialize(lambda);
        this.redexes = RedexFinder.getRedexList(lambda, Environment.getEnvironment().getBoolean("eta_reduction"));
    }

    public short[] getData() {
        return this.data;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = this.lambda.toString().replace("\\", "\u03bb");
        }
        return this.text;
    }

    public List<IRedexNode> getRedexes() {
        return Collections.unmodifiableList(this.redexes);
    }

    @Override
    public boolean isNormalForm() {
        return this.redexes.isEmpty();
    }

    public int hashCode() {
        return 31 * this.data.length ^ this.data[0] ^ this.data[this.data.length >> 1];
    }

    private boolean equals(LambdaNode n) {
        if (this.data.length != n.data.length) {
            return false;
        }
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] != n.data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof LambdaNode && this.equals((LambdaNode)o);
    }

    public String toString() {
        return this.lambda.toString();
    }
}

