/*
 * Decompiled with CFR 0.152.
 */
package lambda.reduction;

import java.util.Set;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IDContext;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.ast.VariableCollector;
import lambda.macro.MacroDefinition;
import lambda.reduction.ReductionRule;

public class Reducer {
    private static ReductionVisitor visitor;

    public static Result reduce(Lambda lambda, MacroDefinition macroDef, IRedexNode redex) {
        if (lambda == null || macroDef == null || redex == null) {
            throw new NullPointerException();
        }
        if (visitor == null) {
            visitor = new ReductionVisitor();
        }
        visitor.macroDef = macroDef;
        visitor.redex = redex;
        return visitor.reduce(lambda);
    }

    private static class ReductionVisitor
    implements Lambda.VisitorRP<Lambda, IDContext> {
        private MacroDefinition macroDef;
        private IRedexNode redex;
        private ReductionRule appliedRule = ReductionRule.NONE;

        private ReductionVisitor() {
        }

        @Override
        public Lambda visit(ASTAbstract abs, IDContext context) {
            if (abs == this.redex && abs.e.isApplication()) {
                ASTApply app = (ASTApply)abs.e;
                if (app.rexpr.isLiteral()) {
                    VariableCollector vc;
                    Set<String> fv;
                    ASTLiteral x = (ASTLiteral)app.rexpr;
                    if (abs.name.equals(x.name) && !(fv = (vc = new VariableCollector(app.lexpr)).getFreeVariables()).contains(x.name)) {
                        this.appliedRule = ReductionRule.ETA_REDUCTION;
                        return app.lexpr;
                    }
                }
            }
            IDContext nc = IDContext.deriveContext(context);
            nc.addBoundedName(abs.name);
            Lambda ret = this.reduce(abs.e, nc);
            if (ret != abs.e) {
                return new ASTAbstract(abs.originalName, abs.name, ret);
            }
            return abs;
        }

        @Override
        public Lambda visit(ASTApply app, IDContext context) {
            if (app == this.redex && app.lexpr.isAbstraction()) {
                ASTAbstract abs = (ASTAbstract)app.lexpr;
                this.appliedRule = ReductionRule.BETA_REDUCTION;
                return abs.apply(context, app.rexpr);
            }
            Lambda ret = this.reduce(app.lexpr, context);
            if (ret != app.lexpr) {
                return new ASTApply(ret, app.rexpr);
            }
            ret = this.reduce(app.rexpr, context);
            if (ret != app.rexpr) {
                return new ASTApply(app.lexpr, ret);
            }
            return app;
        }

        @Override
        public Lambda visit(ASTLiteral l, IDContext context) {
            return l;
        }

        @Override
        public Lambda visit(ASTMacro m, IDContext context) {
            Lambda l;
            if (m == this.redex && (l = this.macroDef.expandMacro(m.name)) != null) {
                this.appliedRule = ReductionRule.MACRO_EXPANSION;
                return l;
            }
            return m;
        }

        public Result reduce(Lambda lambda) {
            Lambda ret;
            return new Result(ret, this.appliedRule, (ret = this.reduce(lambda, IDContext.createContext())) != lambda);
        }

        private Lambda reduce(Lambda lambda, IDContext context) {
            return lambda.accept(this, context);
        }
    }

    public static class Result {
        public final Lambda lambda;
        public final ReductionRule appliedRule;
        public final boolean reduced;

        public Result(Lambda lambda, ReductionRule appliedRule, boolean reduced) {
            this.lambda = lambda;
            this.appliedRule = appliedRule;
            this.reduced = reduced;
        }
    }
}

