/*
 * Decompiled with CFR 0.152.
 */
package lambda.reduction;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.ast.VariableCollector;

public class RedexFinder {
    private static VisitorImpl visitor;
    private static LOVisitor loVisitor;

    public static IRedexNode getLeftMostOuterMostRedex(Lambda lambda, boolean etaEnabled) {
        if (loVisitor == null) {
            loVisitor = new LOVisitor();
        }
        loVisitor.etaEnabled = etaEnabled;
        return lambda.accept(loVisitor);
    }

    public static boolean isNormalForm(Lambda lambda, boolean etaEnabled) {
        return RedexFinder.getLeftMostOuterMostRedex(lambda, etaEnabled) == null;
    }

    public static List<IRedexNode> getRedexList(Lambda lambda) {
        return RedexFinder.getRedexList(lambda, false);
    }

    public static List<IRedexNode> getRedexList(Lambda lambda, boolean enableEta) {
        if (visitor == null) {
            visitor = new VisitorImpl();
        }
        visitor.etaEnabled = enableEta;
        ArrayList<IRedexNode> redexes = new ArrayList<IRedexNode>();
        lambda.accept(visitor, redexes);
        return redexes;
    }

    private static boolean isBetaRedex(ASTApply app) {
        return app.lexpr.isAbstraction();
    }

    private static boolean isEtaRedex(ASTAbstract abs) {
        if (abs.e.isApplication()) {
            ASTApply app = (ASTApply)abs.e;
            if (app.rexpr.isLiteral()) {
                VariableCollector vc;
                Set<String> fv;
                ASTLiteral x = (ASTLiteral)app.rexpr;
                if (abs.name.equals(x.name) && !(fv = (vc = new VariableCollector(app.lexpr)).getFreeVariables()).contains(x.name)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static class LOVisitor
    implements Lambda.VisitorR<IRedexNode> {
        private boolean etaEnabled;

        private LOVisitor() {
        }

        @Override
        public IRedexNode visit(ASTAbstract abs) {
            if (this.etaEnabled && RedexFinder.isEtaRedex(abs)) {
                return abs;
            }
            return abs.e.accept(this);
        }

        @Override
        public IRedexNode visit(ASTApply app) {
            if (RedexFinder.isBetaRedex(app)) {
                return app;
            }
            IRedexNode redex = app.lexpr.accept(this);
            if (redex == null) {
                redex = app.rexpr.accept(this);
            }
            return redex;
        }

        @Override
        public IRedexNode visit(ASTLiteral literal) {
            return null;
        }

        @Override
        public IRedexNode visit(ASTMacro macro) {
            return macro;
        }
    }

    private static class VisitorImpl
    implements Lambda.VisitorP<List<IRedexNode>> {
        private boolean etaEnabled;

        private VisitorImpl() {
        }

        @Override
        public void visit(ASTAbstract abs, List<IRedexNode> redexes) {
            if (this.etaEnabled && RedexFinder.isEtaRedex(abs)) {
                redexes.add(abs);
            }
            abs.e.accept(this, redexes);
        }

        @Override
        public void visit(ASTApply app, List<IRedexNode> redexes) {
            if (RedexFinder.isBetaRedex(app)) {
                redexes.add(app);
            }
            app.lexpr.accept(this, redexes);
            app.rexpr.accept(this, redexes);
        }

        @Override
        public void visit(ASTLiteral literal, List<IRedexNode> redexes) {
        }

        @Override
        public void visit(ASTMacro macro, List<IRedexNode> redexes) {
            redexes.add(macro);
        }
    }
}

