/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import javax.swing.GroupLayout;
import javax.swing.UIManager;

public final class GUIUtils {
    private static String[] availableFontFamilyNames;

    public static void setVerticalLayout(Container host) {
        GUIUtils.setVerticalLayout(host, true, true);
    }

    public static void setVerticalLayout(Container host, boolean gap, boolean containerGap) {
        GUIUtils.setGroupLayout(host, gap, containerGap, true);
    }

    public static void setHorizontalLayout(Container host) {
        GUIUtils.setHorizontalLayout(host, true, true);
    }

    public static void setHorizontalLayout(Container host, boolean gap, boolean containerGap) {
        GUIUtils.setGroupLayout(host, gap, containerGap, false);
    }

    private static void setGroupLayout(Container host, boolean gap, boolean containerGap, boolean vertical) {
        GroupLayout gl = new GroupLayout(host);
        host.setLayout(gl);
        gl.setAutoCreateGaps(gap);
        gl.setAutoCreateContainerGaps(containerGap);
        GroupLayout.SequentialGroup sg = gl.createSequentialGroup();
        GroupLayout.ParallelGroup pg = gl.createParallelGroup(vertical ? GroupLayout.Alignment.LEADING : GroupLayout.Alignment.BASELINE);
        Component[] componentArray = host.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            sg = sg.addComponent(c);
            pg = pg.addComponent(c, 0, -2, Short.MAX_VALUE);
            ++n2;
        }
        if (vertical) {
            gl.setVerticalGroup(sg);
            gl.setHorizontalGroup(pg);
        } else {
            gl.setVerticalGroup(pg);
            gl.setHorizontalGroup(sg);
        }
    }

    public static void setLookAndFeelToSystem() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void preloadFontNames() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        availableFontFamilyNames = ge.getAvailableFontFamilyNames();
    }

    public static String[] getAvailableFontFamilyNames() {
        if (availableFontFamilyNames == null) {
            GUIUtils.preloadFontNames();
        }
        return availableFontFamilyNames;
    }
}

