/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.lambdalabel;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import lambda.gui.lambdalabel.LambdaLabel;
import lambda.gui.lambdalabel.LambdaLabelMetrics;

public class LambdaLabelDrawer
implements LambdaLabel.VisitorP<Boolean> {
    private Graphics g;
    private FontMetrics fm;
    private Point point;

    public void draw(Graphics g, LambdaLabel lambda) {
        this.g = g;
        this.fm = g.getFontMetrics();
        LambdaLabelMetrics.getWidth(g, lambda);
        this.point = new Point(0, this.fm.getAscent() + this.fm.getLeading());
        g.setColor(Color.BLACK);
        lambda.accept(this, false);
    }

    public void draw(Graphics g, LambdaLabel lambda, int h) {
        this.g = g;
        this.fm = g.getFontMetrics();
        LambdaLabelMetrics.getWidth(g, lambda);
        this.point = new Point(0, (h - this.fm.getHeight()) / 2 + this.fm.getAscent() + this.fm.getLeading());
        g.setColor(Color.BLACK);
        lambda.accept(this, false);
    }

    public void draw(Graphics g, LambdaLabel lambda, int x, int y, int h) {
        this.g = g;
        this.fm = g.getFontMetrics();
        LambdaLabelMetrics.getWidth(g, lambda);
        this.point = new Point(x, y + (h - this.fm.getHeight()) / 2 + this.fm.getAscent() + this.fm.getLeading());
        g.setColor(Color.BLACK);
        lambda.accept(this, false);
    }

    @Override
    public void visit(LambdaLabel.LiteralLabel l, Boolean paren) {
        String s = l.name;
        if (paren.booleanValue()) {
            this.drawString("(");
        }
        this.drawString(s);
        if (paren.booleanValue()) {
            this.drawString(")");
        }
    }

    @Override
    public void visit(LambdaLabel.ApplyLabel app, Boolean paren) {
        boolean lpar = app.lexpr.isParenRequiredInAppLeft();
        boolean rpar = app.rexpr.isParenRequiredInAppRight();
        if (paren.booleanValue()) {
            this.drawString("(");
        }
        app.lexpr.accept(this, lpar);
        app.rexpr.accept(this, rpar);
        if (paren.booleanValue()) {
            this.drawString(")");
        }
    }

    @Override
    public void visit(LambdaLabel.AbstractLabel abs, Boolean paren) {
        LambdaLabel e = abs;
        String s = "\\";
        while (((LambdaLabel)e).isAbstract()) {
            LambdaLabel.AbstractLabel eAbs = e;
            s = String.valueOf(s) + eAbs.name;
            e = eAbs.body;
        }
        s = String.valueOf(s) + ".";
        if (paren.booleanValue()) {
            this.drawString("(");
        }
        this.drawString(s);
        ((LambdaLabel)e).accept(this, false);
        if (paren.booleanValue()) {
            this.drawString(")");
        }
    }

    @Override
    public void visit(LambdaLabel.MacroLabel macro, Boolean paren) {
        String s = "<" + macro.name + ">";
        if (paren.booleanValue()) {
            this.drawString("(");
        }
        this.drawString(s);
        if (paren.booleanValue()) {
            this.drawString(")");
        }
    }

    @Override
    public void visit(LambdaLabel.RedexWrapper wrap, Boolean paren) {
        this.g.setColor(wrap.color);
        int r = this.fm.getHeight();
        this.g.fillRoundRect(this.point.x + 1, this.point.y - (this.fm.getAscent() + this.fm.getLeading()) + 1, wrap.getWidth() - 2, this.fm.getHeight() - 2, r, r);
        this.g.setColor(Color.BLACK);
        this.point.x += 2;
        wrap.lambda.accept(this, paren);
        this.point.x += 2;
    }

    private void drawString(String s) {
        this.g.drawString(s, this.point.x, this.point.y - this.fm.getLeading());
        this.point.x += this.fm.stringWidth(s);
    }
}

