/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import lambda.Environment;
import lambda.gui.Main;
import lambda.gui.MainFrame;
import lambda.gui.fontdialog.FontDialog;
import lambda.gui.fontdialog.event.FontUpdateListener;

public class MainMenu
extends JMenuBar {
    private MainFrame owner;

    public MainMenu(MainFrame ownerFrame) {
        this.owner = ownerFrame;
        this.setBorder(null);
        int MOD_CTRL = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenu menuFile = new JMenu("File");
        this.add(menuFile);
        JMenuItem itemLoad = new JMenuItem("Load Macros");
        itemLoad.setAccelerator(KeyStroke.getKeyStroke(79, MOD_CTRL));
        itemLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.owner.loadMacroFile();
            }
        });
        menuFile.add(itemLoad);
        menuFile.addSeparator();
        JMenuItem itemExit = new JMenuItem("Exit");
        itemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.owner.dispose();
            }
        });
        menuFile.add(itemExit);
        JMenu menuView = new JMenu("View");
        this.add(menuView);
        JMenuItem itemFont = new JMenuItem("Font");
        itemFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final Environment env = Environment.getEnvironment();
                String defaultFamily = env.get("gui.fontfamily", "");
                int defaultSize = env.getInt("gui.fontsize", 12);
                int defaultAddition = env.getInt("gui.ui.font.addition", 0);
                FontDialog dialog = new FontDialog();
                dialog.setLocationRelativeTo(MainMenu.this.owner);
                dialog.setSelectedFamilyName(defaultFamily);
                dialog.setSelectedFontSize(defaultSize);
                dialog.setFontAddition(defaultAddition);
                dialog.addFontApplyListener(new FontUpdateListener(){

                    @Override
                    public void fontFamilyChanged(String fontFamily) {
                        env.set("gui.fontfamily", fontFamily);
                        Main.reload(env.getGUIFont());
                    }

                    @Override
                    public void fontSizeChanged(int size) {
                        env.set("gui.fontsize", size);
                        Main.reload(env.getGUIFont());
                    }

                    @Override
                    public void uiFontAdditionChanged(int addition) {
                        env.set("gui.ui.font.addition", addition);
                        Main.updateUIFontAddition();
                    }
                });
                if (!dialog.showModal()) {
                    env.set("gui.fontfamily", defaultFamily);
                    env.set("gui.fontsize", defaultSize);
                    env.set("gui.ui.font.addition", defaultAddition);
                    Main.reload(env.getGUIFont());
                    Main.updateUIFontAddition();
                }
            }
        });
        menuView.add(itemFont);
        JMenu menuAbout = new JMenu("About");
        this.add(menuAbout);
        JMenuItem itemVersion = new JMenuItem("Version");
        itemVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.showVersion();
            }
        });
        menuAbout.add(itemVersion);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(null);
    }

    private void showVersion() {
        String s = "";
        s = String.valueOf(s) + "Lambda * Magica version 3.82\n";
        s = String.valueOf(s) + "Release Date: 2013-11-26\n";
        s = String.valueOf(s) + "Copyright (C) 2011-2012 Yuuki.S All Rights Reserved.";
        JOptionPane.showMessageDialog(this.owner, s, "Version Information", 1);
    }
}

