/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import java.awt.Font;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import lambda.Environment;
import lambda.gui.MainFrame;
import lambda.gui.util.GUIUtils;

public class Main {
    private static MainFrame mainFrame;
    private static Map<String, Integer> defaultSizes;

    static {
        defaultSizes = null;
    }

    public static void reload(Font font) {
        mainFrame.setCodeFont(font);
    }

    public static void updateUIFontAddition() {
        if (defaultSizes == null) {
            defaultSizes = new HashMap<String, Integer>();
            for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
                String key = entry.getKey().toString();
                if (!key.toLowerCase().endsWith("font")) continue;
                Font font = UIManager.getFont(key);
                defaultSizes.put(key, font.getSize());
            }
        }
        int a = Environment.getEnvironment().getInt("gui.ui.font.addition", 0);
        for (Map.Entry<String, Integer> entry : defaultSizes.entrySet()) {
            String key = entry.getKey();
            Font font = UIManager.getFont(key);
            float size = entry.getValue() + a;
            if (!(size > 0.0f)) continue;
            UIManager.put(key, new FontUIResource(font.deriveFont(size)));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Window[] windowArray = Window.getWindows();
                    int n = windowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Window window = windowArray[n2];
                        SwingUtilities.updateComponentTreeUI(window);
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void main(String[] args) {
        GUIUtils.preloadFontNames();
        GUIUtils.setLookAndFeelToSystem();
        Main.updateUIFontAddition();
        mainFrame = new MainFrame();
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setLocationRelativeTo(null);
        mainFrame.setVisible(true);
    }
}

