/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast.parser;

import java.util.Scanner;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import lambda.ast.parser.Lexer;
import lambda.ast.parser.LexerException;
import lambda.ast.parser.ParserException;
import lambda.ast.parser.Token;
import lambda.ast.parser.TokenType;

public class Parser {
    private Lexer lexer;
    private Token token;

    public Parser(Lexer lexer) {
        this.lexer = lexer;
    }

    public Lambda parse() throws ParserException {
        this.next();
        Lambda ast = this.abstraction();
        if (this.token.type == TokenType.END) {
            return ast;
        }
        throw new ParserException("Syntax error, extra tokens.", this.token);
    }

    private Lambda abstraction() throws ParserException {
        if (this.token.type == TokenType.LAMBDA) {
            this.next();
            if (this.token.type == TokenType.ID) {
                String id = this.token.text;
                this.next();
                return new ASTAbstract(id, id, this.absList());
            }
            if (this.token.type == TokenType.DOT) {
                throw new ParserException("Syntax error, empty formals.", this.token);
            }
            throw new ParserException("Syntax error, expected variable names.", this.token);
        }
        return this.appList();
    }

    private Lambda absList() throws ParserException {
        if (this.token.type == TokenType.ID) {
            String id = this.token.text;
            this.next();
            return new ASTAbstract(id, id, this.absList());
        }
        if (this.token.type == TokenType.DOT) {
            this.next();
            return this.abstraction();
        }
        throw new ParserException("Syntax error, unexpected token.", this.token);
    }

    private Lambda appList() throws ParserException {
        Lambda e = this.atomic();
        TokenType t = this.token.type;
        while (t == TokenType.ID || t == TokenType.LPAR || t == TokenType.MACRONAME) {
            e = new ASTApply(e, this.atomic());
            t = this.token.type;
        }
        return e;
    }

    private Lambda atomic() throws ParserException {
        switch (this.token.type) {
            case ID: {
                String name = this.token.text;
                this.next();
                return new ASTLiteral(name);
            }
            case MACRONAME: {
                String name = this.token.text;
                this.next();
                return new ASTMacro(name);
            }
            case LPAR: {
                this.next();
                Lambda e = this.abstraction();
                if (this.token.type != TokenType.RPAR) {
                    throw new ParserException("Syntax error, missing ')'.", this.token);
                }
                this.next();
                return e;
            }
        }
        throw new ParserException("Syntax error, unexpected token.", this.token);
    }

    private void next() throws ParserException {
        try {
            this.token = this.lexer.nextToken();
        }
        catch (LexerException e) {
            throw new ParserException("Lexical error, " + e.getMessage(), e.column);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        System.out.println("Type :q to quit.");
        sc = new Scanner(System.in);
        while (true) {
            System.out.print("> ");
            line = sc.nextLine();
            if (line == null || line.equals(":q")) break;
            parser = new Parser(new Lexer(line));
            try {
                ast = parser.parse();
                System.out.println("parsed: " + ast);
                continue;
            }
            catch (ParserException e) {
                System.out.println(line);
                i = 0;
                ** while (i < e.column)
            }
lbl-1000:
            // 1 sources

            {
                System.out.print(' ');
                ++i;
                continue;
            }
lbl19:
            // 1 sources

            System.out.println('^');
            System.out.println(e.getMessage());
        }
    }
}

