/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;

public class VariableCollector {
    private Collector collector = new Collector();

    public VariableCollector(Lambda lambda) {
        lambda.accept(this.collector);
    }

    public Set<String> getFreeVariables() {
        return Collections.unmodifiableSet(this.collector.fv);
    }

    public Set<String> getBoundedVariables() {
        return Collections.unmodifiableSet(this.collector.bv);
    }

    private static class Collector
    implements Lambda.Visitor {
        private Set<String> fv = new HashSet<String>();
        private Set<String> bv = new HashSet<String>();

        private Collector() {
        }

        @Override
        public void visit(ASTAbstract abs) {
            this.bv.add(abs.name);
            abs.e.accept(this);
            this.fv.remove(abs.name);
        }

        @Override
        public void visit(ASTApply app) {
            app.lexpr.accept(this);
            app.rexpr.accept(this);
        }

        @Override
        public void visit(ASTLiteral literal) {
            this.fv.add(literal.name);
        }

        @Override
        public void visit(ASTMacro macro) {
        }
    }
}

