/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;

public class LambdaPrinter
implements Lambda.VisitorR<Lambda> {
    private static final char LAMBDA_CHAR = '\\';
    private StringBuilder buf = new StringBuilder();

    public static String toString(Lambda lambda) {
        LambdaPrinter printer = new LambdaPrinter();
        lambda.accept(printer);
        return printer.buf.toString();
    }

    public String makeString(Lambda lambda) {
        lambda.accept(this);
        return this.buf.toString();
    }

    @Override
    public Lambda visit(ASTAbstract abs) {
        Lambda e = abs;
        this.buf.append('\\');
        while (((Lambda)e).isAbstraction()) {
            ASTAbstract eAbs = e;
            this.buf.append(eAbs.name);
            e = eAbs.e;
        }
        this.buf.append('.');
        ((Lambda)e).accept(this);
        return abs;
    }

    @Override
    public Lambda visit(ASTApply app) {
        boolean rpar;
        Lambda l = app.lexpr;
        Lambda r = app.rexpr;
        boolean lpar = l.isAbstraction();
        boolean bl = rpar = !r.isAtomic();
        if (lpar) {
            this.buf.append('(');
        }
        l.accept(this);
        if (lpar) {
            this.buf.append(')');
        }
        if (rpar) {
            this.buf.append('(');
        }
        r.accept(this);
        if (rpar) {
            this.buf.append(')');
        }
        return app;
    }

    @Override
    public Lambda visit(ASTLiteral literal) {
        this.buf.append(literal.name);
        return literal;
    }

    @Override
    public Lambda visit(ASTMacro macro) {
        this.buf.append('<');
        this.buf.append(macro.name);
        this.buf.append('>');
        return macro;
    }
}

