/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class IDContext {
    protected Set<String> boundedNames = new HashSet<String>();
    protected Map<String, Integer> ids = new HashMap<String, Integer>();

    public Set<String> getBoundedNames() {
        return Collections.unmodifiableSet(this.boundedNames);
    }

    public void addBoundedName(String name) {
        this.boundedNames.add(name);
    }

    public boolean isBounded(String name) {
        return this.boundedNames.contains(name);
    }

    public int define(String name) {
        int id = this.generateFreshId();
        this.ids.put(name, id);
        return id;
    }

    public abstract int find(String var1);

    protected abstract int generateFreshId();

    public static IDContext createContext() {
        return new RootContext();
    }

    public static IDContext deriveContext(IDContext superContext) {
        return new SubContext(superContext);
    }

    private static class RootContext
    extends IDContext {
        private int freshId;

        private RootContext() {
        }

        @Override
        public int find(String name) {
            Integer id = (Integer)this.ids.get(name);
            if (id == null) {
                id = this.define(name);
            }
            return id;
        }

        @Override
        protected int generateFreshId() {
            return this.freshId++;
        }
    }

    private static class SubContext
    extends IDContext {
        private final IDContext superContext;

        public SubContext(IDContext superContext) {
            this.superContext = superContext;
            this.boundedNames.addAll(superContext.boundedNames);
        }

        @Override
        public int find(String name) {
            Integer id = (Integer)this.ids.get(name);
            if (id == null) {
                id = this.superContext.find(name);
            }
            return id;
        }

        @Override
        protected int generateFreshId() {
            return this.superContext.generateFreshId();
        }
    }
}

