/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.ast.parser.ParserException;
import lambda.macro.MacroDefinition;
import lambda.reduction.RedexFinder;
import lambda.reduction.Reducer;
import lambda.reductiongraph.IStateNode;
import lambda.reductiongraph.InfinityNode;
import lambda.reductiongraph.LambdaNode;
import lambda.reductiongraph.gui.GraphNode;
import lambda.reductiongraph.gui.StateFrame;

public class NDMain {
    private static final MacroDefinition MACRO_DEF = new MacroDefinition();
    private static Set<IStateNode> states = new HashSet<IStateNode>();
    private static Map<LambdaNode, Set<IStateNode>> edges = new HashMap<LambdaNode, Set<IStateNode>>();
    private static Map<IStateNode, GraphNode> nodeMapping = new HashMap<IStateNode, GraphNode>();
    private static boolean createdNew;

    private static void addEdge(LambdaNode src, IStateNode dest) {
        Set<IStateNode> dests = edges.get(src);
        if (dests == null) {
            dests = new HashSet<IStateNode>();
            edges.put(src, dests);
        }
        dests.add(dest);
    }

    private static GraphNode addGraphNode(StateFrame f, IStateNode node) {
        GraphNode gn = nodeMapping.get(node);
        if (gn == null) {
            gn = new GraphNode(node.getText());
            nodeMapping.put(node, gn);
            f.addNode(gn);
            createdNew = true;
        } else {
            createdNew = false;
        }
        return gn;
    }

    private static void search(Lambda lambda, int maxDepth) {
        LinkedList<LambdaNode> queue = new LinkedList<LambdaNode>();
        queue.add(new LambdaNode(0, lambda));
        while (!queue.isEmpty()) {
            LambdaNode p = (LambdaNode)queue.poll();
            if (states.contains(p)) continue;
            states.add(p);
            List<IRedexNode> redexes = RedexFinder.getRedexList(p.lambda);
            for (IRedexNode redex : redexes) {
                Reducer.Result ret = Reducer.reduce(p.lambda, MACRO_DEF, redex);
                LambdaNode p2 = new LambdaNode(p.depth + 1, ret.lambda);
                if (p.depth + 1 <= maxDepth || states.contains(p2)) {
                    NDMain.addEdge(p, p2);
                    queue.add(p2);
                    continue;
                }
                NDMain.addEdge(p, InfinityNode.getInstance());
            }
        }
        System.out.println("states = " + states.size());
    }

    private static void searchOnLine(Lambda lambda, int maxDepth) {
        StateFrame f = new StateFrame();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        nodeMapping.clear();
        LinkedList<LambdaNode> queue = new LinkedList<LambdaNode>();
        LambdaNode initial = new LambdaNode(0, lambda);
        GraphNode gnInitial = NDMain.addGraphNode(f, initial);
        f.setInitialNode(gnInitial);
        queue.add(initial);
        while (!queue.isEmpty()) {
            LambdaNode p1 = (LambdaNode)queue.poll();
            if (states.contains(p1)) continue;
            states.add(p1);
            GraphNode gn1 = NDMain.addGraphNode(f, p1);
            List<IRedexNode> redexes = p1.getRedexes();
            if (redexes.isEmpty()) {
                gn1.setAccept(true);
            }
            for (IRedexNode redex : redexes) {
                GraphNode gn2;
                Reducer.Result ret = Reducer.reduce(p1.lambda, MACRO_DEF, redex);
                LambdaNode lambdaNode = new LambdaNode(p1.depth + 1, ret.lambda);
                if (lambdaNode.depth <= maxDepth || states.contains(lambdaNode)) {
                    gn2 = NDMain.addGraphNode(f, lambdaNode);
                    if (lambdaNode.getRedexes().isEmpty()) {
                        gn2.setAccept(true);
                    }
                    if (createdNew) {
                        gn2.setLocation(gn1.getX(), gn1.getY());
                        gn2.setDestination(gn1.getX(), gn1.getY());
                    }
                    queue.add(lambdaNode);
                } else {
                    InfinityNode infNode = InfinityNode.getInstance();
                    gn2 = NDMain.addGraphNode(f, infNode);
                    gn2.setInfinity(true);
                }
                f.addEdges(gn1, gn2);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("states = " + states.size());
    }

    private static void outputGraph() {
        HashMap<IStateNode, Integer> idMap = new HashMap<IStateNode, Integer>();
        int id = 0;
        for (IStateNode iStateNode : states) {
            idMap.put(iStateNode, id++);
        }
        System.out.println("digraph {");
        System.out.println("  ratio=1.0");
        System.out.println("  fontsize=4;");
        for (IStateNode iStateNode : states) {
            if (iStateNode.isNormalForm()) {
                System.out.printf("  %d [label=\"%s\",peripheries=2];\r\n", idMap.get(iStateNode), iStateNode.getText());
                continue;
            }
            System.out.printf("  %d [label=\"%s\"];\r\n", idMap.get(iStateNode), iStateNode.getText());
        }
        for (Map.Entry entry : edges.entrySet()) {
            LambdaNode start = (LambdaNode)entry.getKey();
            System.out.printf("  %d->{", idMap.get(start));
            for (IStateNode end : (Set)entry.getValue()) {
                System.out.printf(" %d", idMap.get(end));
            }
            System.out.println(" };");
        }
        System.out.println("}");
    }

    private static void outputGraphFrame() {
        StateFrame f = new StateFrame();
        f.setDefaultCloseOperation(3);
        HashMap<IStateNode, GraphNode> gns = new HashMap<IStateNode, GraphNode>();
        for (IStateNode iStateNode : states) {
            GraphNode gn = new GraphNode(iStateNode.getText());
            f.addNode(gn);
            gns.put(iStateNode, gn);
            if (!iStateNode.isNormalForm()) continue;
            gn.setAccept(true);
        }
        for (Map.Entry entry : edges.entrySet()) {
            LambdaNode start = (LambdaNode)entry.getKey();
            GraphNode[] ns = new GraphNode[((Set)entry.getValue()).size()];
            int i = 0;
            for (IStateNode end : (Set)entry.getValue()) {
                ns[i++] = (GraphNode)gns.get(end);
            }
            f.addEdges((GraphNode)gns.get(start), ns);
        }
        f.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        System.out.println("ND mode");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return;
                }
                try {
                    Lambda lambda = Lambda.parse(line);
                    NDMain.searchOnLine(lambda, 10);
                }
                catch (ParserException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

