/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lambda.AlphaComparator;
import lambda.Environment;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.macro.MacroDefinition;
import lambda.reduction.RedexFinder;
import lambda.reduction.Reducer;
import lambda.reduction.ReductionRule;

public class LambdaInterpreter {
    private LinkedList<State> states = new LinkedList();
    private State currentState;
    private Lambda sourceLambda;
    private boolean isCyclic;
    private boolean terminated;

    public void startInterpretation(Lambda sourceLambda) {
        this.sourceLambda = sourceLambda;
        this.initialize();
    }

    public void initialize() {
        this.isCyclic = false;
        this.terminated = false;
        this.states.clear();
        this.pushState(new State(0, this.sourceLambda, ReductionRule.NONE));
    }

    public Reducer.Result step(MacroDefinition macros, IRedexNode redex) {
        Reducer.Result result = Reducer.reduce(this.getLambda(), macros, redex);
        this.isCyclic = AlphaComparator.alphaEquiv(this.getLambda(), result.lambda);
        ReductionRule rule = result.appliedRule;
        int stepNumber = this.currentState.stepNumber;
        if (rule == ReductionRule.BETA_REDUCTION || rule == ReductionRule.ETA_REDUCTION) {
            ++stepNumber;
        }
        this.currentState.redex = redex;
        this.pushState(new State(stepNumber, result.lambda, rule));
        return result;
    }

    public void revert() {
        this.pop();
    }

    public boolean isRevertable() {
        return this.states.size() > 1;
    }

    public int getReductionStepCount() {
        return this.currentState.stepNumber;
    }

    public boolean isNormal() {
        boolean etaEnabled = Environment.getEnvironment().getBoolean("eta_reduction");
        return RedexFinder.isNormalForm(this.getLambda(), etaEnabled);
    }

    public boolean isCyclic() {
        return !this.isNormal() && this.isCyclic;
    }

    public boolean isTerminated() {
        return this.terminated || this.isNormal() || this.isCyclic();
    }

    public void terminate() {
        this.terminated = true;
    }

    public Lambda getLambda() {
        return this.currentState.lambda;
    }

    public List<State> getStates() {
        return Collections.unmodifiableList(this.states);
    }

    private void pushState(State s) {
        this.states.addLast(s);
        this.currentState = s;
    }

    private void pop() {
        if (this.isRevertable()) {
            this.states.removeLast();
            this.currentState = this.states.getLast();
        }
    }

    public static class State {
        public final int stepNumber;
        public final Lambda lambda;
        public final ReductionRule appliedRule;
        private IRedexNode redex;

        public State(int stepNumber, Lambda lambda, ReductionRule appliedRule) {
            this.stepNumber = stepNumber;
            this.lambda = lambda;
            this.appliedRule = appliedRule;
        }

        public IRedexNode getReducedRedex() {
            return this.redex;
        }
    }
}

