/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;

public class Environment {
    public static final String APPLICATION_VERSION = "3.82";
    public static final String RELEASE_DATE = "2013-11-26";
    public static final String PROPERTY_FILENAME = "properties.txt";
    public static final String KEY_CONTINUE_STEPS = "continue_steps";
    public static final String KEY_PRINT_STEP = "print_step";
    public static final String KEY_TRACE = "trace";
    public static final String KEY_SHORT = "short";
    public static final String KEY_DATA_CONV = "data_abstraction";
    public static final String KEY_AUTO = "auto";
    public static final String KEY_ETA_REDUCTION = "eta_reduction";
    public static final String KEY_GUI_FONT_FAMILY = "gui.fontfamily";
    public static final String KEY_GUI_FONT_SIZE = "gui.fontsize";
    public static final String KEY_GUI_FONT_ADDITION = "gui.ui.font.addition";
    public static final String KEY_PRINT_BETA_ETA = "print_beta_eta";
    public static final String KEY_LAST_DIRECTORY = "gui.load.lastdir";
    private static Environment instance;
    private Map<String, String> entries = new TreeMap<String, String>();
    private Font guiFont;

    private Environment() {
        this.set(KEY_CONTINUE_STEPS, 500);
        this.set(KEY_TRACE, false);
        this.set(KEY_SHORT, true);
        this.set(KEY_DATA_CONV, false);
        this.set(KEY_AUTO, false);
        this.set(KEY_ETA_REDUCTION, false);
        this.set(KEY_GUI_FONT_FAMILY, "DialogInput");
        this.set(KEY_GUI_FONT_SIZE, 12);
        this.set(KEY_GUI_FONT_ADDITION, 0);
        this.set(KEY_PRINT_BETA_ETA, true);
        this.set(KEY_LAST_DIRECTORY, ".");
    }

    public String get(String key, String defval) {
        String value = this.entries.get(key);
        if (value == null) {
            value = defval;
            this.set(key, value);
        }
        return value;
    }

    public int getInt(String key, int defval) {
        int value;
        try {
            value = Integer.parseInt(this.entries.get(key));
        }
        catch (NumberFormatException e) {
            value = defval;
            this.set(key, value);
        }
        return value;
    }

    public boolean getBoolean(String key) {
        String value = this.entries.get(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        this.set(key, false);
        return false;
    }

    public <T> void set(String key, T value) {
        this.entries.put(key, value.toString());
    }

    public Font getGUIFont() {
        String family = this.get(KEY_GUI_FONT_FAMILY, "DialogInput");
        int size = this.getInt(KEY_GUI_FONT_SIZE, 12);
        if (this.guiFont == null || !this.guiFont.getFamily().equals(family) || this.guiFont.getSize() != size) {
            this.guiFont = new Font(family, 0, size);
        }
        return this.guiFont;
    }

    public static Environment getEnvironment() {
        if (instance == null) {
            Environment.createEnvironment();
        }
        return instance;
    }

    private static void createEnvironment() {
        instance = new Environment();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(PROPERTY_FILENAME)));
            while ((line = reader.readLine()) != null) {
                String[] kv = line.split("\\s*=\\s*");
                if (kv.length != 2) continue;
                Environment.instance.entries.put(kv[0].trim(), kv[1].trim());
            }
            reader.close();
        }
        catch (FileNotFoundException reader) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                instance.save();
            }
        });
    }

    private void save() {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(PROPERTY_FILENAME))));
            for (Map.Entry<String, String> e : this.entries.entrySet()) {
                out.println(String.valueOf(e.getKey()) + "=" + e.getValue());
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

