/*
 * Decompiled with CFR 0.152.
 */
package lambda.reductiongraph.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;

public class GraphNode {
    private static final Color INITIAL_COLOR = new Color(100, 100, 255);
    private static final Color ACCEPT_COLOR = new Color(255, 100, 100);
    private static final Color INFINITY_COLOR = new Color(200, 200, 200);
    private static final Color NODE_COLOR = new Color(100, 255, 100);
    public static int R = 8;
    private String label;
    private int depth = Short.MAX_VALUE;
    private Point2D.Double location = new Point2D.Double();
    private Point2D.Double destination = new Point2D.Double();
    private boolean accept;
    private boolean infinity;
    private boolean animating;

    public GraphNode(String label) {
        this.label = label;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int d) {
        this.depth = d;
    }

    public String getLabel() {
        return this.label;
    }

    public void setInfinity(boolean b) {
        this.infinity = b;
    }

    public boolean isAccept() {
        return this.accept;
    }

    public void setAccept(boolean b) {
        this.accept = b;
    }

    public void setLocation(int x, int y) {
        this.location.x = x;
        this.location.y = y;
        this.animating = true;
    }

    public void setDestination(int x, int y) {
        this.destination.x = x;
        this.destination.y = y;
        this.animating = true;
    }

    public void setX(int x) {
        this.destination.x = x;
        this.animating = true;
    }

    public void setY(int y) {
        this.destination.y = y;
        this.animating = true;
    }

    public int getX() {
        return (int)this.location.x;
    }

    public int getY() {
        return (int)this.location.y;
    }

    public boolean update() {
        if (this.animating) {
            this.location.x += 0.2 * (this.destination.x - this.location.x);
            this.location.y += 0.2 * (this.destination.y - this.location.y);
            if (this.location.distanceSq(this.destination) < 0.1) {
                this.location.setLocation(this.destination);
                this.animating = false;
            }
        }
        return this.animating;
    }

    public void draw(Graphics g, boolean initial) {
        if (this.infinity) {
            g.setColor(INFINITY_COLOR);
        } else if (this.isAccept()) {
            g.setColor(ACCEPT_COLOR);
        } else if (initial) {
            g.setColor(INITIAL_COLOR);
        } else {
            g.setColor(NODE_COLOR);
        }
        g.fillOval(this.getX() - R, this.getY() - R, 2 * R, 2 * R);
        if (R > 4) {
            g.setColor(Color.BLACK);
            g.drawOval(this.getX() - R, this.getY() - R, 2 * R, 2 * R);
            if (this.isAccept()) {
                int r = Math.max(R - 2, 0);
                g.drawOval(this.getX() - r, this.getY() - r, 2 * r, 2 * r);
            }
        }
    }
}

