/*
 * Decompiled with CFR 0.152.
 */
package lambda.reductiongraph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.macro.MacroDefinition;
import lambda.reduction.Reducer;
import lambda.reductiongraph.IStateNode;
import lambda.reductiongraph.InfinityNode;
import lambda.reductiongraph.LambdaNode;
import lambda.reductiongraph.event.SearchEndListener;
import lambda.reductiongraph.gui.DirectedGraphPanel;
import lambda.reductiongraph.gui.GraphNode;

public class StateSearcher {
    private static final MacroDefinition EMPTY_MACRO_DEF = new MacroDefinition();
    private DirectedGraphPanel graphPanel;
    private Lambda lambda;
    private int maxDepth;
    private Map<IStateNode, GraphNode> nodeMapping = new HashMap<IStateNode, GraphNode>();
    private boolean createdNew;
    private int states;
    private EventListenerList listeners = new EventListenerList();
    private Thread thread;

    public StateSearcher(DirectedGraphPanel graphPanel, Lambda lambda, int maxDepth) {
        this.graphPanel = graphPanel;
        this.lambda = lambda;
        this.maxDepth = maxDepth;
    }

    public int getStateCount() {
        return this.states;
    }

    public void startSearch() {
        this.thread = new SearchThread();
        this.thread.setName("SearchThread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void abort() {
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.thread = null;
        }
    }

    public void addSearchEndListener(SearchEndListener l) {
        this.listeners.add(SearchEndListener.class, l);
    }

    private void dispatchSearchEndEvent() {
        SearchEndListener[] searchEndListenerArray = (SearchEndListener[])this.listeners.getListeners(SearchEndListener.class);
        int n = searchEndListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchEndListener l = searchEndListenerArray[n2];
            l.searchEnded();
            ++n2;
        }
    }

    private void searchOnLine() throws InterruptedException {
        this.nodeMapping.clear();
        HashSet<LambdaNode> visited = new HashSet<LambdaNode>();
        LinkedList<LambdaNode> queue = new LinkedList<LambdaNode>();
        LambdaNode initial = new LambdaNode(0, this.lambda);
        GraphNode gnInitial = this.addGraphNode(initial);
        this.graphPanel.setInitialNode(gnInitial);
        queue.add(initial);
        while (!queue.isEmpty()) {
            LambdaNode p1 = (LambdaNode)queue.poll();
            if (visited.contains(p1)) continue;
            visited.add(p1);
            GraphNode gn1 = this.addGraphNode(p1);
            List<IRedexNode> redexes = p1.getRedexes();
            if (redexes.isEmpty()) {
                gn1.setAccept(true);
            }
            for (IRedexNode redex : redexes) {
                GraphNode gn2;
                Reducer.Result ret = Reducer.reduce(p1.lambda, EMPTY_MACRO_DEF, redex);
                LambdaNode lambdaNode = new LambdaNode(p1.depth + 1, ret.lambda);
                if (lambdaNode.depth <= this.maxDepth || visited.contains(lambdaNode)) {
                    gn2 = this.addGraphNode(lambdaNode);
                    if (lambdaNode.getRedexes().isEmpty()) {
                        gn2.setAccept(true);
                    }
                    if (this.createdNew) {
                        gn2.setLocation(gn1.getX(), gn1.getY());
                        gn2.setDestination(gn1.getX(), gn1.getY());
                    }
                    queue.add(lambdaNode);
                } else {
                    InfinityNode infNode = InfinityNode.getInstance();
                    gn2 = this.addGraphNode(infNode);
                    gn2.setInfinity(true);
                }
                this.graphPanel.addEdge(gn1, gn2);
            }
            Thread.sleep(50L);
        }
        this.states = visited.size();
    }

    private GraphNode addGraphNode(IStateNode node) {
        GraphNode gn = this.nodeMapping.get(node);
        if (gn == null) {
            gn = new GraphNode(node.getText());
            this.nodeMapping.put(node, gn);
            this.graphPanel.addNode(gn);
            this.createdNew = true;
        } else {
            this.createdNew = false;
        }
        return gn;
    }

    private class SearchThread
    extends Thread {
        private SearchThread() {
        }

        @Override
        public void run() {
            try {
                try {
                    StateSearcher.this.searchOnLine();
                }
                catch (InterruptedException interruptedException) {
                    StateSearcher.this.dispatchSearchEndEvent();
                }
            }
            finally {
                StateSearcher.this.dispatchSearchEndEvent();
            }
        }
    }
}

