/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.macroview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import lambda.ast.Lambda;

public class MacroDefinitionView
extends JPanel {
    private Set<String> items = new HashSet<String>();
    private DefaultTableModel tableModel;
    private JTable macroTable;

    public MacroDefinitionView() {
        this.setLayout(new BorderLayout());
        this.tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tableModel.addColumn("Name");
        this.tableModel.addColumn("Definition");
        this.macroTable = new JTable(this.tableModel);
        this.macroTable.setSelectionMode(0);
        this.macroTable.setFillsViewportHeight(true);
        this.macroTable.setDragEnabled(false);
        this.macroTable.setRowSelectionAllowed(true);
        this.macroTable.getTableHeader().setReorderingAllowed(false);
        this.macroTable.setRowSorter(new TableRowSorter<DefaultTableModel>(this.tableModel));
        this.add((Component)new JScrollPane(this.macroTable), "Center");
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.macroTable != null) {
            this.macroTable.setFont(font);
            FontMetrics fm = this.getFontMetrics(font);
            this.macroTable.setRowHeight(fm.getHeight());
        }
    }

    public void addMacro(String name, Lambda def) {
        if (this.items.contains(name)) {
            int row = 0;
            while (row < this.tableModel.getRowCount()) {
                if (name.equals(this.tableModel.getValueAt(row, 0))) {
                    this.tableModel.removeRow(row);
                    break;
                }
                ++row;
            }
        } else {
            this.items.add(name);
        }
        this.tableModel.addRow(new Object[]{name, def.toString()});
    }

    public void clearList() {
        this.items.clear();
        this.tableModel.setRowCount(0);
    }
}

