/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.lambdalabel;

import lambda.gui.lambdalabel.LambdaLabel;

public class LambdaLabelStringBuilder {
    private static VisitorImpl visitor = new VisitorImpl();

    public static String toString(LambdaLabel lambda) {
        StringBuilder sb = new StringBuilder();
        lambda.accept(visitor, sb);
        return sb.toString();
    }

    private static class VisitorImpl
    implements LambdaLabel.VisitorP<StringBuilder> {
        private VisitorImpl() {
        }

        @Override
        public void visit(LambdaLabel.LiteralLabel l, StringBuilder sb) {
            sb.append(l.name);
        }

        @Override
        public void visit(LambdaLabel.ApplyLabel app, StringBuilder sb) {
            boolean lpar = app.lexpr.isParenRequiredInAppLeft();
            boolean rpar = app.rexpr.isParenRequiredInAppRight();
            if (lpar) {
                sb.append('(');
            }
            app.lexpr.accept(this, sb);
            if (lpar) {
                sb.append(')');
            }
            if (rpar) {
                sb.append('(');
            }
            app.rexpr.accept(this, sb);
            if (rpar) {
                sb.append(')');
            }
        }

        @Override
        public void visit(LambdaLabel.AbstractLabel abs, StringBuilder sb) {
            LambdaLabel e = abs;
            sb.append('\\');
            while (((LambdaLabel)e).isAbstract()) {
                LambdaLabel.AbstractLabel eAbs = e;
                sb.append(eAbs.name);
                e = eAbs.body;
            }
            sb.append('.');
            ((LambdaLabel)e).accept(this, sb);
        }

        @Override
        public void visit(LambdaLabel.MacroLabel macro, StringBuilder sb) {
            sb.append('<');
            sb.append(macro.name);
            sb.append('>');
        }

        @Override
        public void visit(LambdaLabel.RedexWrapper wrap, StringBuilder sb) {
            wrap.lambda.accept(this, sb);
        }
    }
}

