/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.lambdalabel;

import java.awt.FontMetrics;
import java.awt.Graphics;
import lambda.gui.lambdalabel.LambdaLabel;

public class LambdaLabelMetrics {
    private static MeasureVisitor visitor;

    public static int getWidth(Graphics g, LambdaLabel lambdaLabel) {
        if (visitor == null) {
            visitor = new MeasureVisitor(2);
        }
        return visitor.calculateSize(g.getFontMetrics(), lambdaLabel);
    }

    private static class MeasureVisitor
    implements LambdaLabel.VisitorRP<Integer, Boolean> {
        private FontMetrics fm;
        private int padding;

        public MeasureVisitor(int padding) {
            this.padding = padding;
        }

        public int calculateSize(FontMetrics fm, LambdaLabel lambdaLabel) {
            this.fm = fm;
            return lambdaLabel.accept(this, false);
        }

        @Override
        public Integer visit(LambdaLabel.LiteralLabel l, Boolean paren) {
            int w = this.getParenedWidth(l.name, paren);
            l.setWidth(w);
            return l.getWidth();
        }

        @Override
        public Integer visit(LambdaLabel.ApplyLabel app, Boolean paren) {
            boolean lpar = app.lexpr.isParenRequiredInAppLeft();
            boolean rpar = app.rexpr.isParenRequiredInAppRight();
            int width = app.lexpr.accept(this, lpar) + app.rexpr.accept(this, rpar);
            if (paren.booleanValue()) {
                width += this.getParenWidth();
            }
            app.setWidth(width);
            return width;
        }

        @Override
        public Integer visit(LambdaLabel.AbstractLabel abs, Boolean paren) {
            LambdaLabel e = abs;
            int width = this.fm.charWidth('\\');
            while (((LambdaLabel)e).isAbstract()) {
                LambdaLabel.AbstractLabel eAbs = e;
                width += this.fm.stringWidth(eAbs.name);
                e = eAbs.body;
            }
            width += this.fm.charWidth('.');
            width += ((LambdaLabel)e).accept(this, false).intValue();
            if (paren.booleanValue()) {
                width += this.getParenWidth();
            }
            abs.setWidth(width);
            return abs.getWidth();
        }

        @Override
        public Integer visit(LambdaLabel.MacroLabel macro, Boolean paren) {
            int w = this.getParenedWidth("<" + macro.name + ">", paren);
            macro.setWidth(w);
            return macro.getWidth();
        }

        @Override
        public Integer visit(LambdaLabel.RedexWrapper wrap, Boolean paren) {
            int w = wrap.lambda.accept(this, paren);
            wrap.setWidth(w + 2 * this.padding);
            return wrap.getWidth();
        }

        private int getParenWidth() {
            return this.fm.charWidth('(') + this.fm.charWidth(')');
        }

        private int getParenedWidth(String s, boolean paren) {
            int w = this.getWidth(s);
            if (paren) {
                w += this.getParenWidth();
            }
            return w;
        }

        private int getWidth(String s) {
            return this.fm.stringWidth(s);
        }
    }
}

