/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.lambdalabel;

import java.awt.Color;

public abstract class LambdaLabel {
    private int width;

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public abstract boolean isParenRequiredInAppLeft();

    public abstract boolean isParenRequiredInAppRight();

    public abstract boolean isAbstract();

    public abstract boolean isAtomic();

    public abstract <T> void accept(VisitorP<T> var1, T var2);

    public abstract <T> T accept(VisitorR<T> var1);

    public abstract <TRet, TParam> TRet accept(VisitorRP<TRet, TParam> var1, TParam var2);

    public static LiteralLabel literal(String name) {
        return new LiteralLabel(name);
    }

    public static ApplyLabel apply(LambdaLabel x, LambdaLabel y) {
        return new ApplyLabel(x, y);
    }

    public static AbstractLabel abs(String name, LambdaLabel e) {
        return new AbstractLabel(name, e);
    }

    public static MacroLabel macro(String name) {
        return new MacroLabel(name);
    }

    public static RedexWrapper wrap(LambdaLabel l, Color c) {
        return new RedexWrapper(l, c);
    }

    public static class AbstractLabel
    extends LambdaLabel {
        public final String name;
        public final LambdaLabel body;

        public AbstractLabel(String name, LambdaLabel body) {
            this.name = name;
            this.body = body;
        }

        @Override
        public boolean isParenRequiredInAppLeft() {
            return true;
        }

        @Override
        public boolean isParenRequiredInAppRight() {
            return true;
        }

        @Override
        public boolean isAbstract() {
            return true;
        }

        @Override
        public boolean isAtomic() {
            return false;
        }

        @Override
        public <T> void accept(VisitorP<T> visitor, T param) {
            visitor.visit(this, param);
        }

        @Override
        public <T> T accept(VisitorR<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public <TRet, TParam> TRet accept(VisitorRP<TRet, TParam> visitor, TParam param) {
            return visitor.visit(this, param);
        }
    }

    public static class ApplyLabel
    extends LambdaLabel {
        public final LambdaLabel lexpr;
        public final LambdaLabel rexpr;

        public ApplyLabel(LambdaLabel x, LambdaLabel y) {
            this.lexpr = x;
            this.rexpr = y;
        }

        @Override
        public boolean isParenRequiredInAppLeft() {
            return false;
        }

        @Override
        public boolean isParenRequiredInAppRight() {
            return true;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isAtomic() {
            return false;
        }

        @Override
        public <T> void accept(VisitorP<T> visitor, T param) {
            visitor.visit(this, param);
        }

        @Override
        public <T> T accept(VisitorR<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public <TRet, TParam> TRet accept(VisitorRP<TRet, TParam> visitor, TParam param) {
            return visitor.visit(this, param);
        }
    }

    public static class LiteralLabel
    extends LambdaLabel {
        public final String name;

        public LiteralLabel(String name) {
            this.name = name;
        }

        @Override
        public boolean isParenRequiredInAppLeft() {
            return false;
        }

        @Override
        public boolean isParenRequiredInAppRight() {
            return false;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isAtomic() {
            return true;
        }

        @Override
        public <T> void accept(VisitorP<T> visitor, T param) {
            visitor.visit(this, param);
        }

        @Override
        public <T> T accept(VisitorR<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public <TRet, TParam> TRet accept(VisitorRP<TRet, TParam> visitor, TParam param) {
            return visitor.visit(this, param);
        }
    }

    public static class MacroLabel
    extends LambdaLabel {
        public final String name;

        public MacroLabel(String name) {
            this.name = name;
        }

        @Override
        public boolean isParenRequiredInAppLeft() {
            return false;
        }

        @Override
        public boolean isParenRequiredInAppRight() {
            return false;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isAtomic() {
            return true;
        }

        @Override
        public <T> void accept(VisitorP<T> visitor, T param) {
            visitor.visit(this, param);
        }

        @Override
        public <T> T accept(VisitorR<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public <TRet, TParam> TRet accept(VisitorRP<TRet, TParam> visitor, TParam param) {
            return visitor.visit(this, param);
        }
    }

    public static class RedexWrapper
    extends LambdaLabel {
        public final LambdaLabel lambda;
        public final Color color;

        public RedexWrapper(LambdaLabel lambda, Color color) {
            this.lambda = lambda;
            this.color = color;
        }

        @Override
        public boolean isParenRequiredInAppLeft() {
            return this.lambda.isParenRequiredInAppLeft();
        }

        @Override
        public boolean isParenRequiredInAppRight() {
            return this.lambda.isParenRequiredInAppRight();
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isAtomic() {
            return this.lambda.isAtomic();
        }

        @Override
        public <T> void accept(VisitorP<T> visitor, T param) {
            visitor.visit(this, param);
        }

        @Override
        public <T> T accept(VisitorR<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public <TRet, TParam> TRet accept(VisitorRP<TRet, TParam> visitor, TParam param) {
            return visitor.visit(this, param);
        }
    }

    public static interface VisitorP<T> {
        public void visit(LiteralLabel var1, T var2);

        public void visit(ApplyLabel var1, T var2);

        public void visit(AbstractLabel var1, T var2);

        public void visit(MacroLabel var1, T var2);

        public void visit(RedexWrapper var1, T var2);
    }

    public static interface VisitorR<T> {
        public T visit(LiteralLabel var1);

        public T visit(ApplyLabel var1);

        public T visit(AbstractLabel var1);

        public T visit(MacroLabel var1);

        public T visit(RedexWrapper var1);
    }

    public static interface VisitorRP<TRet, TParam> {
        public TRet visit(LiteralLabel var1, TParam var2);

        public TRet visit(ApplyLabel var1, TParam var2);

        public TRet visit(AbstractLabel var1, TParam var2);

        public TRet visit(MacroLabel var1, TParam var2);

        public TRet visit(RedexWrapper var1, TParam var2);
    }
}

