/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.fontdialog;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lambda.gui.fontdialog.event.FontUpdateListener;
import lambda.gui.util.GUIUtils;

public class FontDialog
extends JDialog {
    private String initSelectedName;
    private JComboBox familyNames;
    private JSpinner fontSize;
    private JLabel labelFontAddition;
    private int fontAddition;
    private boolean approved;
    private List<FontUpdateListener> fontApplyListeners = new ArrayList<FontUpdateListener>();

    public FontDialog() {
        this.setTitle("Font Setting");
        this.setDefaultCloseOperation(2);
        JPanel editorFontPanel = new JPanel();
        editorFontPanel.setBorder(BorderFactory.createTitledBorder("Editor Font"));
        JLabel label1 = new JLabel("Font face:");
        editorFontPanel.add(label1);
        this.familyNames = new JComboBox();
        Dimension dim = this.familyNames.getPreferredSize();
        dim.width = 160;
        this.familyNames.setPreferredSize(dim);
        this.familyNames.setMaximumSize(dim);
        this.familyNames.setMinimumSize(dim);
        this.familyNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontDialog.this.dispatchFontFamilyChangeEvent();
            }
        });
        editorFontPanel.add(this.familyNames);
        String[] stringArray = GUIUtils.getAvailableFontFamilyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.familyNames.addItem(name);
            ++n2;
        }
        this.familyNames.setSelectedItem(this.initSelectedName);
        JLabel label2 = new JLabel("Font size:");
        editorFontPanel.add(label2);
        this.fontSize = new JSpinner(new SpinnerNumberModel(12, 5, 120, 1));
        this.fontSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FontDialog.this.dispatchFontSizeChangeEvent();
            }
        });
        editorFontPanel.add(this.fontSize);
        GroupLayout gl = new GroupLayout(editorFontPanel);
        editorFontPanel.setLayout(gl);
        gl.setAutoCreateContainerGaps(true);
        gl.setAutoCreateGaps(true);
        gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(label1).addComponent(this.familyNames)).addGroup(gl.createSequentialGroup().addComponent(label2).addComponent(this.fontSize)));
        gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label1).addComponent(this.familyNames)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label2).addComponent(this.fontSize)));
        JPanel panelAddition = new JPanel();
        panelAddition.setBorder(BorderFactory.createTitledBorder("UI Font Size"));
        this.labelFontAddition = new JLabel("+0");
        panelAddition.add(this.labelFontAddition);
        JButton buttonInc = new JButton("+");
        buttonInc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontDialog.this.setFontAddition(FontDialog.this.getFontAddition() + 1);
                FontDialog.this.dispatchUIFontAdditionChangeEvent();
                FontDialog.this.pack();
            }
        });
        panelAddition.add(buttonInc);
        JButton buttonDec = new JButton("-");
        buttonDec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontDialog.this.setFontAddition(FontDialog.this.getFontAddition() - 1);
                FontDialog.this.dispatchUIFontAdditionChangeEvent();
                FontDialog.this.pack();
            }
        });
        panelAddition.add(buttonDec);
        this.add(panelAddition);
        JButton buttonOK = new JButton("OK");
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontDialog.this.approved = true;
                FontDialog.this.dispose();
            }
        });
        this.add(buttonOK);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontDialog.this.dispose();
            }
        });
        this.add(buttonCancel);
        GroupLayout gl2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(gl2);
        gl2.setAutoCreateContainerGaps(true);
        gl2.setAutoCreateGaps(true);
        gl2.setHorizontalGroup(gl2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl2.createParallelGroup().addComponent(editorFontPanel).addComponent(panelAddition)).addGroup(gl2.createSequentialGroup().addComponent(buttonOK).addComponent(buttonCancel)));
        gl2.setVerticalGroup(gl2.createSequentialGroup().addComponent(editorFontPanel).addComponent(panelAddition).addGroup(gl2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(buttonOK).addComponent(buttonCancel)));
        gl2.linkSize(buttonOK, buttonCancel);
        this.pack();
    }

    public void setSelectedFont(Font font) {
        String family = font.getFamily();
        int size = font.getSize();
        this.familyNames.setSelectedItem(family);
        this.fontSize.setValue(size);
    }

    public void setSelectedFamilyName(String family) {
        this.initSelectedName = family;
        this.familyNames.setSelectedItem(family);
    }

    public void setSelectedFontSize(int size) {
        this.fontSize.setValue(size);
    }

    public void setFontAddition(int addition) {
        this.fontAddition = addition;
        this.labelFontAddition.setText(String.format("%+d", this.fontAddition));
    }

    public String getSelectedFamilyName() {
        return (String)this.familyNames.getSelectedItem();
    }

    public int getSelectedFontSize() {
        return (Integer)this.fontSize.getValue();
    }

    public int getFontAddition() {
        return this.fontAddition;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public boolean isCanceled() {
        return !this.approved;
    }

    public boolean showModal() {
        this.approved = false;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setVisible(true);
        return this.approved;
    }

    public void addFontApplyListener(FontUpdateListener l) {
        this.fontApplyListeners.add(l);
    }

    public void removeFontApplyListener(FontUpdateListener l) {
        this.fontApplyListeners.remove(l);
    }

    private void dispatchFontFamilyChangeEvent() {
        for (FontUpdateListener l : this.fontApplyListeners) {
            l.fontFamilyChanged(this.getSelectedFamilyName());
        }
    }

    private void dispatchFontSizeChangeEvent() {
        for (FontUpdateListener l : this.fontApplyListeners) {
            l.fontSizeChanged(this.getSelectedFontSize());
        }
    }

    private void dispatchUIFontAdditionChangeEvent() {
        for (FontUpdateListener l : this.fontApplyListeners) {
            l.uiFontAdditionChanged(this.getFontAddition());
        }
    }
}

