/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lambda.Environment;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.gui.lambdalabel.LambdaLabel;
import lambda.gui.lambdalabel.LambdaLabelBuilder;
import lambda.gui.lambdalabel.LambdaLabelDrawer;
import lambda.gui.lambdalabel.LambdaLabelMetrics;
import lambda.reduction.RedexFinder;
import util.Pair;

public class RedexView
extends JPanel {
    private static final Color HOVER_BACK_COLOR = new Color(255, 255, 200);
    private static final Color TRIANGLE_COLOR = new Color(192, 192, 255);
    private LambdaLabelBuilder builder = new LambdaLabelBuilder();
    private List<Pair<IRedexNode, LambdaLabel>> labels = new ArrayList<Pair<IRedexNode, LambdaLabel>>();
    private Insets margin = new Insets(0, 0, 0, 0);
    private int height = -1;
    private int maxWidth;
    private int hoverIndex = -1;
    private int selectedIndex = -1;

    public RedexView() {
        MouseHandler mh = new MouseHandler();
        this.addMouseListener(mh);
        this.addMouseMotionListener(mh);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.height = this.getFontMetrics(font).getHeight();
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.margin.set(top, left, bottom, right);
        this.calcPreferredSize();
    }

    public void clearLabels() {
        this.labels.clear();
        this.maxWidth = 0;
        this.hoverIndex = -1;
        this.selectedIndex = -1;
    }

    private void addLabel(IRedexNode r, LambdaLabel l) {
        this.labels.add(Pair.of(r, l));
        this.calcPreferredSize();
    }

    private void calcPreferredSize() {
        Graphics g = this.getGraphics();
        this.maxWidth = 0;
        for (Pair<IRedexNode, LambdaLabel> p : this.labels) {
            this.maxWidth = Math.max(this.maxWidth, LambdaLabelMetrics.getWidth(g, (LambdaLabel)p._2));
        }
        int w = this.maxWidth + this.height / 2 + this.margin.left + this.margin.right;
        int h = this.height * this.labels.size() + this.margin.top + this.margin.bottom;
        this.setPreferredSize(new Dimension(w, h));
    }

    public void setRedexes(Lambda lambda) {
        this.clearLabels();
        for (IRedexNode redex : RedexFinder.getRedexList(lambda, Environment.getEnvironment().getBoolean("eta_reduction"))) {
            LambdaLabel label = this.builder.createLambdaLabel(lambda, redex);
            this.addLabel(redex, label);
        }
        this.setSelectedIndex(0);
    }

    public IRedexNode getSelectedRedex() {
        int i = this.getSelectedIndex();
        if (i >= 0 && i < this.labels.size()) {
            return (IRedexNode)this.labels.get((int)i)._1;
        }
        return null;
    }

    public int getLabelCount() {
        return this.labels.size();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.labels.size()) {
            this.selectedIndex = index;
            this.repaint();
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    private void dispatchActionEvent() {
        ActionEvent e = new ActionEvent(this, 0, "selected");
        ActionListener[] actionListenerArray = (ActionListener[])this.listenerList.getListeners(ActionListener.class);
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener l = actionListenerArray[n2];
            l.actionPerformed(e);
            ++n2;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.labels.isEmpty()) {
            String s = "No Redexes";
            FontMetrics fm = g.getFontMetrics();
            int sw = fm.stringWidth(s);
            int sh = fm.getHeight();
            g.setColor(Color.LIGHT_GRAY);
            g.drawString(s, (this.getWidth() - sw) / 2, (this.getHeight() - sh) / 2 + fm.getLeading() + fm.getAscent());
            return;
        }
        g.translate(this.margin.left, this.margin.top);
        int width = this.getWidth() - (this.margin.left + this.margin.right);
        if (this.hoverIndex != -1) {
            g.setColor(HOVER_BACK_COLOR);
            g.fillRect(this.height / 2, this.hoverIndex * this.height, width - this.height / 2, this.height);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.translate(this.height / 2, 0);
        LambdaLabelDrawer drawer = new LambdaLabelDrawer();
        int i = 0;
        while (i < this.labels.size()) {
            Pair<IRedexNode, LambdaLabel> p = this.labels.get(i);
            drawer.draw(g, (LambdaLabel)p._2, 0, i * this.height, this.height);
            ++i;
        }
        g.translate(-this.height / 2, 0);
        if (this.selectedIndex != -1) {
            g.setColor(TRIANGLE_COLOR);
            this.drawTriangle(g, 0, this.selectedIndex * this.height + this.height / 2);
        }
        g.translate(-this.margin.left, -this.margin.top);
    }

    private void drawTriangle(Graphics g, int x, int y) {
        int s = Math.max(this.height / 3, 1);
        g.translate(x, y);
        int[] nArray = new int[3];
        nArray[1] = s;
        int[] nArray2 = new int[3];
        nArray2[0] = -s;
        nArray2[2] = s;
        g.fillPolygon(nArray, nArray2, 3);
        g.translate(-x, -y);
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.updateHoverIndex(e);
            RedexView.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RedexView.this.hoverIndex = -1;
            RedexView.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.updateHoverIndex(e);
                if (RedexView.this.hoverIndex != -1) {
                    RedexView.this.selectedIndex = RedexView.this.hoverIndex;
                }
                RedexView.this.repaint();
                if (e.getClickCount() >= 2) {
                    RedexView.this.dispatchActionEvent();
                }
            }
        }

        private void updateHoverIndex(MouseEvent e) {
            RedexView.this.hoverIndex = (e.getY() - ((RedexView)RedexView.this).margin.top) / RedexView.this.height;
            if (RedexView.this.hoverIndex < 0 || RedexView.this.labels.size() <= RedexView.this.hoverIndex) {
                RedexView.this.hoverIndex = -1;
            }
        }
    }
}

