/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import extgui.LineEditor;
import extgui.flatsplitpane.FlatSplitPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lambda.Environment;
import lambda.LaTeXStringBuilder;
import lambda.LambdaInterpreter;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.ast.MacroExpander;
import lambda.ast.VariableCollector;
import lambda.ast.parser.ParserException;
import lambda.conversion.Converter;
import lambda.gui.MainMenu;
import lambda.gui.RedexView;
import lambda.gui.SimpleTextDialog;
import lambda.gui.macroview.MacroDefinitionView;
import lambda.gui.util.GUIUtils;
import lambda.gui.util.LMFileFilter;
import lambda.macro.MacroDefinition;
import lambda.reduction.RedexFinder;
import lambda.reduction.Reducer;
import lambda.reduction.ReductionRule;
import lambda.reductiongraph.event.SearchEndListener;
import lambda.reductiongraph.gui.ReductionGraphView;
import lambda.system.CommandDelegate;
import lambda.system.CommandProcessor;
import util.nullable.NullableBool;
import util.nullable.NullableInt;

public class MainFrame
extends JFrame {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("[HH:mm:ss]");
    private JTabbedPane tabbedPane;
    private LineEditor inputField;
    private JButton buttonStep;
    private JCheckBox checkPrintStep;
    private JCheckBox checkShort;
    private JCheckBox checkEtaEnabled;
    private JCheckBox checkDataConv;
    private JCheckBox checkAuto;
    private JCheckBox checkTraceInAuto;
    private JCheckBox checkPrintBetaEta;
    private JSpinner spinnerMaxSteps;
    private JButton buttonResume;
    private JButton buttonLaTeX;
    private JButton buttonStop;
    private JButton buttonClear;
    private RedexView redexView;
    private JTextArea output;
    private JTextArea systemOutput;
    private MacroDefinitionView macroView;
    private JFileChooser fileChooser;
    private Environment env = Environment.getEnvironment();
    private MacroDefinition macros = new MacroDefinition();
    private final CommandProcessor commands = new CommandProcessor();
    private final LambdaInterpreter interpreter = new LambdaInterpreter();
    private boolean autoRunning;
    private AutoRunningThread thread;

    public MainFrame() {
        this.setTitle("Lambda * Magica 3.82");
        this.setJMenuBar(new MainMenu(this));
        JPanel leftPanel = new JPanel(new BorderLayout());
        JPanel inputPanel = new JPanel(new BorderLayout());
        this.inputField = new LineEditor();
        this.inputField.setFont(this.env.getGUIFont());
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.processInput();
            }
        });
        inputPanel.add((Component)this.inputField, "Center");
        this.buttonStep = new JButton("step");
        this.buttonStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.processInput();
            }
        });
        inputPanel.add((Component)this.buttonStep, "East");
        leftPanel.add((Component)inputPanel, "North");
        JPanel buttonPanel = new JPanel();
        this.output = new JTextArea();
        this.output.setEditable(false);
        this.output.setFont(this.env.getGUIFont());
        this.systemOutput = new JTextArea();
        this.systemOutput.setEditable(false);
        this.systemOutput.setFont(this.env.getGUIFont());
        final FlatSplitPane split = new FlatSplitPane(0, true);
        split.setTopComponent(new JScrollPane(this.output));
        split.setBottomComponent(new JScrollPane(this.systemOutput));
        leftPanel.add((Component)split, "Center");
        JPanel pAuto = this.createAutoModeConfigurationPanel();
        buttonPanel.add(pAuto);
        JPanel pReduction = new JPanel();
        pReduction.setLayout(new BoxLayout(pReduction, 1));
        pReduction.setBorder(BorderFactory.createTitledBorder("Reduction"));
        this.checkEtaEnabled = this.createOptionCheckBox("eta_reduction", "enable eta-reduction");
        pReduction.add(this.checkEtaEnabled);
        buttonPanel.add(pReduction);
        JPanel pPrinting = new JPanel();
        pPrinting.setLayout(new BoxLayout(pPrinting, 1));
        pPrinting.setBorder(BorderFactory.createTitledBorder("Printing"));
        this.checkPrintStep = this.createOptionCheckBox("print_step", "print step");
        this.checkPrintBetaEta = this.createOptionCheckBox("print_beta_eta", "print beta/eta");
        this.checkShort = this.createOptionCheckBox("short", "short printing");
        this.checkDataConv = this.createOptionCheckBox("data_abstraction", "show nat/bool data");
        pPrinting.add(this.checkPrintStep);
        pPrinting.add(this.checkPrintBetaEta);
        pPrinting.add(this.checkShort);
        pPrinting.add(this.checkDataConv);
        buttonPanel.add(pPrinting);
        this.buttonLaTeX = new JButton("generate LaTeX source");
        this.buttonLaTeX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.generateLaTeX();
            }
        });
        buttonPanel.add(this.buttonLaTeX);
        this.buttonClear = new JButton("clear output");
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.output.setText("");
            }
        });
        buttonPanel.add(this.buttonClear);
        JButton buttonClearMacros = new JButton("clear macros");
        buttonClearMacros.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.clearMacros();
            }
        });
        buttonPanel.add(buttonClearMacros);
        GUIUtils.setVerticalLayout(buttonPanel);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("General", buttonPanel);
        this.redexView = new RedexView();
        this.redexView.setBackground(Color.WHITE);
        this.redexView.setFont(this.env.getGUIFont());
        this.redexView.setMargin(5, 5, 5, 5);
        this.redexView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.stepNormal();
            }
        });
        this.tabbedPane.add("Redex", new JScrollPane(this.redexView));
        this.macroView = new MacroDefinitionView();
        this.macroView.setFont(this.env.getGUIFont());
        this.tabbedPane.addTab("Macros", this.macroView);
        final ReductionGraphView rgView = new ReductionGraphView();
        rgView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = MainFrame.this.inputField.getText().trim();
                if (!s.isEmpty()) {
                    MainFrame.this.output.setText("");
                    MainFrame.this.inputField.saveHistory();
                    MainFrame.this.inputField.setText("");
                    try {
                        Lambda lambda = Lambda.parse(s);
                        MacroExpander expander = new MacroExpander(MainFrame.this.macros);
                        lambda = expander.expand(lambda, true);
                        MainFrame.this.println("- Start: " + lambda);
                        if (expander.isSucceeded()) {
                            rgView.startSearch(lambda);
                        } else {
                            MainFrame.this.println("- Input contains undefined macro.");
                        }
                    }
                    catch (ParserException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        rgView.addSearchEndListener(new SearchEndListener(){

            @Override
            public void searchEnded() {
                MainFrame.this.println("- End: count = " + rgView.getStoredNodeCount());
            }
        });
        this.tabbedPane.addTab("ReductionGraph", rgView);
        final FlatSplitPane sp = new FlatSplitPane();
        sp.setContinuousLayout(true);
        sp.setLeftComponent(leftPanel);
        sp.setRightComponent(this.tabbedPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                sp.setDividerLocation(0.7);
                sp.setResizeWeight(0.5);
                split.setDividerLocation(0.8);
                split.setResizeWeight(0.9);
            }
        });
        sp.setDividerLocation(Short.MAX_VALUE);
        this.add(sp);
        this.setSize(700, 600);
        this.setupAcceleration();
        this.initializeCommands();
    }

    public void loadMacroFile() {
        int ret;
        if (this.fileChooser == null) {
            File cd = new File(this.env.get("gui.load.lastdir", "."));
            this.fileChooser = new JFileChooser(cd);
            this.fileChooser.setDialogTitle("Load Macro File");
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            this.fileChooser.setFileFilter(LMFileFilter.getInstance());
        }
        if ((ret = this.fileChooser.showOpenDialog(this)) == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.loadFile(file);
        }
        this.env.set("gui.load.lastdir", this.fileChooser.getCurrentDirectory().getPath());
    }

    private JPanel createAutoModeConfigurationPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder("Auto Mode"));
        this.checkAuto = this.createOptionCheckBox("auto", "auto reduction");
        this.checkAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.updateAutoModePanel();
            }
        });
        this.checkTraceInAuto = this.createOptionCheckBox("trace", "show trace in auto mode");
        JPanel stepPanel = new JPanel();
        this.spinnerMaxSteps = new JSpinner(new SpinnerNumberModel(this.env.getInt("continue_steps", 100), 0, 1000, 1));
        this.spinnerMaxSteps.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.this.env.set("continue_steps", MainFrame.this.spinnerMaxSteps.getValue());
            }
        });
        stepPanel.add(new JLabel("step limit:"));
        stepPanel.add(this.spinnerMaxSteps);
        GUIUtils.setHorizontalLayout(stepPanel, true, true);
        this.buttonResume = new JButton("continue");
        this.buttonResume.setEnabled(false);
        this.buttonResume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.autoRunning && MainFrame.this.thread != null) {
                    MainFrame.this.thread.resumeAuto();
                }
            }
        });
        this.buttonStop = new JButton("stop");
        this.buttonStop.setEnabled(false);
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.autoRunning && MainFrame.this.thread != null) {
                    MainFrame.this.stopAuto();
                }
            }
        });
        p.add(this.checkAuto);
        p.add(this.checkTraceInAuto);
        p.add(stepPanel);
        p.add(this.buttonResume);
        p.add(this.buttonStop);
        GUIUtils.setVerticalLayout(p);
        this.updateAutoModePanel();
        return p;
    }

    private void updateAutoModePanel() {
        boolean b = this.checkAuto.isSelected();
        this.checkTraceInAuto.setEnabled(b);
        this.spinnerMaxSteps.setEnabled(b);
    }

    private void setupAcceleration() {
        int mod = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        String keyInc = "font.size.increase";
        String keyDec = "font.size.decrease";
        String keyDef = "font.size.default";
        String keyRev = "revert";
        InputMap imap = this.getRootPane().getInputMap(2);
        imap.put(KeyStroke.getKeyStroke(521, mod), keyInc);
        imap.put(KeyStroke.getKeyStroke(107, mod), keyInc);
        imap.put(KeyStroke.getKeyStroke(59, mod), keyInc);
        imap.put(KeyStroke.getKeyStroke(45, mod), keyDec);
        imap.put(KeyStroke.getKeyStroke(109, mod), keyDec);
        imap.put(KeyStroke.getKeyStroke(48, mod), keyDef);
        imap.put(KeyStroke.getKeyStroke(10, 64), keyRev);
        ActionMap amap = this.getRootPane().getActionMap();
        amap.put(keyInc, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Environment env = Environment.getEnvironment();
                int size = env.getInt("gui.fontsize", 12);
                if (size < 120) {
                    env.set("gui.fontsize", size + 1);
                    MainFrame.this.setCodeFont(env.getGUIFont());
                }
            }
        });
        amap.put(keyDec, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Environment env = Environment.getEnvironment();
                int size = env.getInt("gui.fontsize", 12);
                if (5 < size) {
                    env.set("gui.fontsize", size - 1);
                    MainFrame.this.setCodeFont(env.getGUIFont());
                }
            }
        });
        amap.put(keyDef, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Environment env = Environment.getEnvironment();
                env.set("gui.fontsize", 12);
                MainFrame.this.setCodeFont(env.getGUIFont());
            }
        });
        amap.put(keyRev, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MainFrame.this.autoRunning) {
                    MainFrame.this.stepBackward();
                }
            }
        });
    }

    private JCheckBox createOptionCheckBox(final String key, String text) {
        final JCheckBox checkBox = new JCheckBox(text);
        checkBox.setSelected(this.env.getBoolean(key));
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.env.set(key, checkBox.isSelected());
            }
        });
        return checkBox;
    }

    public void setCodeFont(Font font) {
        this.inputField.setFont(font);
        this.output.setFont(font);
        this.systemOutput.setFont(font);
        this.redexView.setFont(font);
        this.macroView.setFont(font);
    }

    private void processInput() {
        String s = this.inputField.getText().trim();
        if (!s.isEmpty()) {
            this.output.setText("");
            this.inputField.saveHistory();
            this.inputField.setText("");
            this.start(s);
        } else {
            this.stepNormal();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void start(String text) {
        block8: {
            if (this.autoRunning) {
                return;
            }
            if ((text = text.trim()).startsWith(":")) {
                a = text.split("\\s+");
                cmd = a[0];
                if (!this.commands.invokeCommand(cmd, params = Arrays.copyOfRange(a, 1, a.length))) {
                    this.println("- unknown command " + cmd);
                }
            } else if (!text.isEmpty()) {
                try {
                    this.evalLine(text);
                    break block8;
                }
                catch (ParserException e) {
                    s = "";
                    i = 0;
                    ** while (i < e.column)
                }
lbl-1000:
                // 1 sources

                {
                    s = String.valueOf(s) + ' ';
                    ++i;
                    continue;
                }
lbl20:
                // 1 sources

                this.println(text);
                this.println(String.valueOf(s) + '^');
                this.println("- " + e.getMessage());
            }
        }
    }

    private IRedexNode getDefaultRedex() {
        boolean eta = this.env.getBoolean("eta_reduction");
        return RedexFinder.getLeftMostOuterMostRedex(this.interpreter.getLambda(), eta);
    }

    private IRedexNode getSelectedRedex() {
        IRedexNode redex = this.redexView.getSelectedRedex();
        return redex != null ? redex : this.getDefaultRedex();
    }

    private boolean stepReduction(boolean auto) {
        IRedexNode redex;
        if (this.interpreter.isTerminated()) {
            return false;
        }
        IRedexNode iRedexNode = redex = auto ? this.getDefaultRedex() : this.getSelectedRedex();
        if (redex == null) {
            return false;
        }
        boolean succeeded = true;
        Reducer.Result result = this.interpreter.step(this.macros, redex);
        if (result.reduced) {
            if (!auto || this.env.getBoolean("trace")) {
                StringBuilder sb = new StringBuilder();
                if (this.env.getBoolean("print_step")) {
                    if (result.appliedRule == ReductionRule.MACRO_EXPANSION) {
                        sb.append("  -: ");
                    } else {
                        sb.append(String.format("%3d: ", this.interpreter.getReductionStepCount()));
                    }
                }
                if (this.env.getBoolean("print_beta_eta")) {
                    switch (result.appliedRule) {
                        case BETA_REDUCTION: {
                            sb.append("\u03b2");
                            break;
                        }
                        case ETA_REDUCTION: {
                            sb.append("\u03b7");
                            break;
                        }
                        case MACRO_EXPANSION: {
                            sb.append(" ");
                            break;
                        }
                    }
                }
                switch (result.appliedRule) {
                    case BETA_REDUCTION: 
                    case ETA_REDUCTION: {
                        sb.append(" --> ");
                        break;
                    }
                    case MACRO_EXPANSION: {
                        sb.append("   = ");
                        break;
                    }
                }
                String s = this.interpreter.getLambda().toString();
                if (this.env.getBoolean("short") && s.length() > 75) {
                    sb.append(s.substring(0, 35));
                    sb.append(" ... ");
                    sb.append(s.substring(s.length() - 35, s.length()));
                } else {
                    sb.append(s);
                }
                this.println(sb.toString());
            }
            if (this.checkIfCycled() || this.checkIfNormalForm()) {
                this.reductionTerminated();
                succeeded = false;
            }
        } else {
            this.reductionTerminated();
            succeeded = false;
        }
        return succeeded;
    }

    private boolean stepNormal() {
        boolean ret = this.stepReduction(false);
        this.updateRedexView(this.interpreter.getLambda());
        return ret;
    }

    private synchronized boolean stepAuto() {
        return this.stepReduction(true);
    }

    private void stepBackward() {
        if (!this.autoRunning && !this.interpreter.isTerminated() && this.interpreter.isRevertable()) {
            this.interpreter.revert();
            this.deleteLine();
            this.updateRedexView(this.interpreter.getLambda());
        }
    }

    private void showConvertedData(Lambda lambda) {
        NullableBool boolValue;
        NullableInt natValue = Converter.toNat(lambda);
        if (natValue.hasValue()) {
            this.println("  = " + natValue + " (as nat)");
        }
        if ((boolValue = Converter.toBool(lambda)).hasValue()) {
            this.println("  = " + boolValue + " (as bool)");
        }
    }

    private boolean checkIfNormalForm() {
        boolean etaEnabled;
        Lambda lambda = this.interpreter.getLambda();
        if (RedexFinder.isNormalForm(lambda, etaEnabled = this.env.getBoolean("eta_reduction"))) {
            this.printEndState(lambda, "(normal form)");
            return true;
        }
        return false;
    }

    private boolean checkIfCycled() {
        if (this.interpreter.isCyclic()) {
            this.printEndState(this.interpreter.getLambda(), "(cyclic reduction)");
            return true;
        }
        return false;
    }

    private void printEndState(Lambda lambda, String label) {
        MacroExpander expander = new MacroExpander(this.macros);
        lambda = expander.expand(lambda, true);
        this.println("==> " + lambda + "    " + label);
        if (this.env.getBoolean("data_abstraction")) {
            this.showConvertedData(lambda);
        }
    }

    private void reductionTerminated() {
        this.buttonStop.setEnabled(false);
    }

    private void updateRedexView(Lambda lambda) {
        this.redexView.setRedexes(lambda);
        this.redexView.revalidate();
        this.redexView.repaint();
    }

    private void defineMacro(String name, String expr) {
        try {
            Lambda lambda = Lambda.parse(expr);
            this.macros.defineMacro(name, lambda);
            this.macroView.addMacro(name, lambda);
            this.println(String.format("- <%s> is defined as %s", name, lambda));
            VariableCollector vc = new VariableCollector(lambda);
            Set<String> fv = vc.getFreeVariables();
            if (!fv.isEmpty()) {
                this.println(String.format("- Warning: <%s> contains free variables %s", name, fv));
            }
        }
        catch (ParserException e) {
            this.println("- " + e.getMessage());
        }
    }

    private void readMacro(String line) {
        if (line.indexOf(61) != -1) {
            String[] v = line.split("\\s*=\\s*");
            if (v.length == 2) {
                this.defineMacro(v[0], v[1]);
            } else {
                this.println("- Invalid expression: " + line);
            }
        }
    }

    private void evalLine(String line) throws ParserException {
        if (line.indexOf(61) != -1) {
            this.readMacro(line);
        } else {
            Lambda lambda = Lambda.parse(line);
            this.println(lambda.toString());
            this.interpreter.startInterpretation(lambda);
            if (this.checkIfNormalForm()) {
                this.reductionTerminated();
            } else if (!this.env.getBoolean("auto")) {
                this.tabbedPane.setSelectedIndex(1);
                this.buttonStep.requestFocus();
                this.updateRedexView(lambda);
            } else {
                this.startAuto();
            }
        }
    }

    private void startAuto() {
        this.autoRunning = true;
        this.buttonStop.setEnabled(true);
        this.buttonStep.setEnabled(false);
        this.thread = new AutoRunningThread();
        this.thread.start();
    }

    private void stopAuto() {
        if (this.thread != null) {
            this.interpreter.terminate();
            this.autoRunning = false;
            this.thread.resumeAuto();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.printSystemMessage("Stopped.");
        }
    }

    private void loadFile(File file) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            this.println("- load '" + file.getName() + "'");
            while ((line = reader.readLine()) != null) {
                int c = line.indexOf(35);
                if (c != -1) {
                    line = line.substring(0, c);
                }
                if ((line = line.trim()).isEmpty()) continue;
                this.readMacro(line);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            this.println("- cannot open file \"" + file.getPath() + "\"");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadFile(String path) {
        File file = new File(path);
        if (!file.exists() && !path.endsWith(".lm.txt")) {
            file = new File(String.valueOf(path) + ".lm.txt");
        }
        this.loadFile(file);
    }

    private void clearMacros() {
        this.macros.clearMacros();
        this.macroView.clearList();
        this.println("- macros were cleared.");
    }

    private void initializeCommands() {
        this.commands.add(":q", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                MainFrame.this.dispose();
            }
        });
        this.commands.add(":l", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                if (params.length == 0) {
                    File cd = new File(".");
                    File[] fileArray = cd.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file.isFile() && file.getName().endsWith(".lm.txt")) {
                            MainFrame.this.loadFile(file.getName());
                        }
                        ++n2;
                    }
                } else {
                    String[] stringArray = params;
                    int n = params.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String fileName = stringArray[n3];
                        MainFrame.this.loadFile(fileName);
                        ++n3;
                    }
                }
            }
        });
        this.commands.add(":f", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                if (params.length >= 1) {
                    String expr = "";
                    String[] stringArray = params;
                    int n = params.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        expr = String.valueOf(expr) + s + " ";
                        ++n2;
                    }
                    try {
                        Lambda lambda = Lambda.parse(expr);
                        MacroExpander expander = new MacroExpander(MainFrame.this.macros);
                        MainFrame.this.println(expander.expand(lambda, true).toString());
                    }
                    catch (ParserException e) {
                        MainFrame.this.println(e.getMessage());
                    }
                }
            }
        });
        this.commands.add(":c", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                MainFrame.this.clearMacros();
            }
        });
        this.commands.add(":pwd", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                MainFrame.this.println(new File("").getAbsolutePath());
            }
        });
        this.commands.add(":?", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                MainFrame.this.println("- :?         - show this help.");
                MainFrame.this.println("- :f <expr>  - expand all macros and show expression.");
                MainFrame.this.println("- :l <path>  - load lines from a text file.");
                MainFrame.this.println("- :c         - clear all macros.");
                MainFrame.this.println("- :pwd       - print working directory.");
                MainFrame.this.println("- :q         - quit interpreter.");
            }
        });
    }

    private void generateLaTeX() {
        StringBuilder buf = new StringBuilder();
        LaTeXStringBuilder builder = new LaTeXStringBuilder();
        buf.append("\\begin{eqnarray*}\n");
        for (LambdaInterpreter.State s : this.interpreter.getStates()) {
            switch (s.appliedRule) {
                case NONE: {
                    buf.append("&& ");
                    break;
                }
                case BETA_REDUCTION: {
                    buf.append("&\\longrightarrow_\\beta& ");
                    break;
                }
                case ETA_REDUCTION: {
                    buf.append("&\\longrightarrow_\\eta& ");
                    break;
                }
                case MACRO_EXPANSION: {
                    buf.append("&=& ");
                }
            }
            buf.append(builder.build(s.lambda, s.getReducedRedex()));
            buf.append(" \\\\\n");
        }
        buf.append("\\end{eqnarray*}\n");
        SimpleTextDialog dialog = new SimpleTextDialog();
        dialog.setTextAreaFont(this.output.getFont());
        dialog.setText(buf.toString());
        dialog.setVisible(true);
    }

    private synchronized void println(String line) {
        this.output.append(line);
        this.output.append(System.getProperty("line.separator"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.output.setCaretPosition(MainFrame.this.output.getText().length());
            }
        });
    }

    private synchronized void printSystemMessage(String text) {
        String s = String.valueOf(DATE_FORMAT.format(new Date())) + " " + text;
        this.systemOutput.append(s);
        this.systemOutput.append("\n");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.systemOutput.setCaretPosition(MainFrame.this.systemOutput.getText().length());
            }
        });
    }

    private synchronized void deleteLine() {
        String text = this.output.getText().trim();
        int i = text.lastIndexOf(10);
        if (i != -1) {
            text = text.substring(0, i + 1);
            this.output.setText(text);
        }
    }

    private class AutoRunningThread
    extends Thread {
        private int nextLimit;
        private boolean noLimit;
        private boolean suspended;

        public AutoRunningThread() {
            this.setName("AutoRunningThread");
            this.setDaemon(true);
            this.updateLimit();
        }

        public synchronized void resumeAuto() {
            MainFrame.this.printSystemMessage("Resumed.");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.buttonResume.setEnabled(false);
                }
            });
            this.updateLimit();
            this.suspended = false;
            this.notifyAll();
        }

        @Override
        public void run() {
            try {
                try {
                    while (MainFrame.this.autoRunning) {
                        if (!MainFrame.this.stepAuto()) {
                            break;
                        }
                        if (!this.isLimited()) continue;
                        MainFrame.this.printSystemMessage(String.valueOf(MainFrame.this.interpreter.getReductionStepCount()) + " steps done. Continue?");
                        this.suspendAuto();
                    }
                }
                catch (StackOverflowError e) {
                    MainFrame.this.println("Fatal Error: generated too large structure");
                    this.finalizeAuto();
                }
            }
            finally {
                this.finalizeAuto();
            }
        }

        private void updateLimit() {
            int limit = MainFrame.this.env.getInt("continue_steps", 100);
            if (this.noLimit) {
                if (limit >= 0) {
                    this.nextLimit = MainFrame.this.interpreter.getReductionStepCount() + limit;
                    this.noLimit = false;
                }
            } else if (limit == 0) {
                this.noLimit = true;
            } else {
                this.nextLimit += limit;
            }
        }

        private boolean isLimited() {
            return !this.noLimit && MainFrame.this.interpreter.getReductionStepCount() >= this.nextLimit;
        }

        private synchronized void suspendAuto() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.buttonResume.setEnabled(true);
                }
            });
            this.suspended = true;
            try {
                while (this.suspended) {
                    this.notifyAll();
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private void finalizeAuto() {
            MainFrame.this.autoRunning = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.buttonResume.setEnabled(false);
                    MainFrame.this.buttonStop.setEnabled(false);
                    MainFrame.this.buttonStep.setEnabled(true);
                }
            });
            MainFrame.this.thread = null;
        }
    }
}

