/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import util.Pair;

class RenameGenerator
implements Lambda.VisitorRP<Lambda, Pair<Set<String>, Map<String, String>>> {
    private Set<String> renameTarget;

    public RenameGenerator(Set<String> target) {
        this.renameTarget = target;
    }

    public Lambda rename(Set<String> boundedNames, Lambda lambda) {
        return lambda.accept(this, new Pair(new HashSet<String>(boundedNames), new HashMap()));
    }

    @Override
    public Lambda visit(ASTAbstract abs, Pair<Set<String>, Map<String, String>> cxt) {
        Set bv = (Set)cxt._1;
        Map renameMap = (Map)cxt._2;
        HashSet<String> bv2 = new HashSet<String>(bv);
        HashMap<String, String> renameMap2 = new HashMap<String, String>(renameMap);
        if (this.renameTarget.contains(abs.name)) {
            String newName = RenameGenerator.generateName(bv);
            renameMap2.put(abs.name, newName);
            bv2.add(newName);
            Lambda e = abs.e.accept(this, Pair.of(bv2, renameMap2));
            return new ASTAbstract(abs.originalName, newName, e);
        }
        bv2.add(abs.name);
        Lambda e = abs.e.accept(this, Pair.of(bv2, renameMap2));
        return e == abs.e ? abs : new ASTAbstract(abs.originalName, abs.name, e);
    }

    @Override
    public Lambda visit(ASTApply app, Pair<Set<String>, Map<String, String>> cxt) {
        Lambda l = app.lexpr.accept(this, cxt);
        Lambda r = app.rexpr.accept(this, cxt);
        return l == app.lexpr && r == app.rexpr ? app : new ASTApply(l, r);
    }

    @Override
    public Lambda visit(ASTLiteral literal, Pair<Set<String>, Map<String, String>> cxt) {
        if (((Map)cxt._2).containsKey(literal.name)) {
            return new ASTLiteral(literal.originalName, (String)((Map)cxt._2).get(literal.name));
        }
        return literal;
    }

    @Override
    public Lambda visit(ASTMacro macro, Pair<Set<String>, Map<String, String>> cxt) {
        return macro;
    }

    private static String generateName(Set<String> bounded) {
        String name;
        char c = 'a';
        while (c <= 'z') {
            name = Character.toString(c);
            if (!bounded.contains(name)) {
                return name;
            }
            c = (char)(c + '\u0001');
        }
        c = 'A';
        while (c <= 'Z') {
            name = Character.toString(c);
            if (!bounded.contains(name)) {
                return name;
            }
            c = (char)(c + '\u0001');
        }
        int i = 0;
        while (i < 1000000) {
            name = "$" + i;
            if (!bounded.contains(name)) {
                return name;
            }
            ++i;
        }
        throw new RuntimeException("failed to generate name");
    }
}

