/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import lambda.macro.MacroDefinition;

public class MacroExpander
implements Lambda.VisitorR<Lambda> {
    private MacroDefinition macroDef;
    private boolean recursive;
    private boolean unexpanded;

    public MacroExpander(MacroDefinition macroDef) {
        this.macroDef = macroDef;
    }

    public Lambda expand(Lambda lambda) {
        return this.expand(lambda, false);
    }

    public Lambda expand(Lambda lambda, boolean recursive) {
        this.recursive = recursive;
        this.unexpanded = false;
        return lambda.accept(this);
    }

    public boolean isSucceeded() {
        return !this.unexpanded;
    }

    @Override
    public Lambda visit(ASTAbstract abs) {
        Lambda e = abs.e.accept(this);
        return e == abs.e ? abs : new ASTAbstract(abs.originalName, abs.name, e);
    }

    @Override
    public Lambda visit(ASTApply app) {
        Lambda e1 = app.lexpr.accept(this);
        Lambda e2 = app.rexpr.accept(this);
        return e1 == app.lexpr && e2 == app.rexpr ? app : new ASTApply(e1, e2);
    }

    @Override
    public Lambda visit(ASTLiteral literal) {
        return literal;
    }

    @Override
    public Lambda visit(ASTMacro macro) {
        Lambda l = this.macroDef.expandMacro(macro.name);
        if (l != null) {
            return this.recursive ? l.accept(this) : l;
        }
        System.out.println("- <" + macro.name + "> is undefined");
        this.unexpanded = true;
        return macro;
    }
}

