/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IDContext;
import lambda.ast.LambdaPrinter;
import lambda.ast.parser.Lexer;
import lambda.ast.parser.Parser;
import lambda.ast.parser.ParserException;

public abstract class Lambda {
    public abstract Lambda deepCopy();

    public boolean isMacro() {
        return false;
    }

    public boolean isLiteral() {
        return false;
    }

    public boolean isApplication() {
        return false;
    }

    public boolean isAbstraction() {
        return false;
    }

    public boolean isAtomic() {
        return this.isMacro() || this.isLiteral();
    }

    protected abstract Lambda substitute(IDContext var1, String var2, Lambda var3);

    public abstract void accept(Visitor var1);

    public abstract <TParam> void accept(VisitorP<TParam> var1, TParam var2);

    public abstract <TRet> TRet accept(VisitorR<TRet> var1);

    public abstract <TRet, TParam> TRet accept(VisitorRP<TRet, TParam> var1, TParam var2);

    public String toString() {
        return LambdaPrinter.toString(this);
    }

    public static Lambda parse(String text) throws ParserException {
        Parser parser = new Parser(new Lexer(text));
        return parser.parse();
    }

    public static interface Visitor {
        public void visit(ASTAbstract var1);

        public void visit(ASTApply var1);

        public void visit(ASTLiteral var1);

        public void visit(ASTMacro var1);
    }

    public static interface VisitorP<TParam> {
        public void visit(ASTAbstract var1, TParam var2);

        public void visit(ASTApply var1, TParam var2);

        public void visit(ASTLiteral var1, TParam var2);

        public void visit(ASTMacro var1, TParam var2);
    }

    public static interface VisitorR<TRet> {
        public TRet visit(ASTAbstract var1);

        public TRet visit(ASTApply var1);

        public TRet visit(ASTLiteral var1);

        public TRet visit(ASTMacro var1);
    }

    public static interface VisitorRP<TRet, TParam> {
        public TRet visit(ASTAbstract var1, TParam var2);

        public TRet visit(ASTApply var1, TParam var2);

        public TRet visit(ASTLiteral var1, TParam var2);

        public TRet visit(ASTMacro var1, TParam var2);
    }
}

