/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;

public class LaTeXStringBuilder {
    private static VisitorImpl visitor = new VisitorImpl();

    public String build(Lambda lambda) {
        return this.build(lambda, null);
    }

    public String build(Lambda lambda, IRedexNode redex) {
        visitor.redex = redex;
        return lambda.accept(visitor);
    }

    private static class VisitorImpl
    implements Lambda.VisitorR<String> {
        private IRedexNode redex;

        private VisitorImpl() {
        }

        @Override
        public String visit(ASTAbstract abs) {
            ASTAbstract a;
            String s = "\\lambda{";
            Lambda l = abs;
            do {
                a = l;
                s = String.valueOf(s) + a.name;
            } while ((l = a.e).isAbstraction() && l != this.redex);
            s = String.valueOf(s) + "}.";
            s = String.valueOf(s) + l.accept(this);
            if (abs == this.redex) {
                s = VisitorImpl.addUnderline(s);
            }
            return s;
        }

        @Override
        public String visit(ASTApply app) {
            Lambda l = app.lexpr;
            Lambda r = app.rexpr;
            boolean lpar = l.isAbstraction();
            boolean rpar = r.isAbstraction() || r.isApplication();
            String s1 = l.accept(this);
            if (lpar) {
                s1 = "(" + s1 + ")";
            }
            String s2 = r.accept(this);
            if (rpar) {
                s2 = "(" + s2 + ")";
            }
            if (app == this.redex) {
                s1 = VisitorImpl.addUnderline(s1);
                s2 = VisitorImpl.addUnderline(s2);
            }
            return String.valueOf(s1) + "\\," + s2;
        }

        @Override
        public String visit(ASTLiteral l) {
            return l.name;
        }

        @Override
        public String visit(ASTMacro m) {
            String s = "\\overline{\\rm\\bf\\strut " + m.name + "}";
            if (m == this.redex) {
                s = VisitorImpl.addUnderline(s);
            }
            return s;
        }

        private static String addUnderline(String s) {
            return "\\underline{\\strut " + s + "}";
        }
    }
}

