/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;
import lambda.LambdaMatcher;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import lambda.ast.parser.ParserException;

public class AlphaComparator {
    private static AlphaVisitor visitor = new AlphaVisitor();

    public static boolean alphaEquiv(Lambda lambda1, Lambda lambda2) {
        visitor.initialize();
        return lambda1.accept(visitor, lambda2);
    }

    public static void main(String[] args) {
        System.out.println("AlpahEquivTest");
        Scanner sc = new Scanner(System.in);
        while (true) {
            System.out.print("input e1> ");
            String s1 = sc.nextLine();
            if (s1 == null || (s1 = s1.trim()).isEmpty()) break;
            System.out.print("input e2> ");
            String s2 = sc.nextLine();
            if (s2 == null || (s2 = s2.trim()).isEmpty()) break;
            try {
                Lambda e1 = Lambda.parse(s1);
                Lambda e2 = Lambda.parse(s2);
                System.out.println("e1 = " + e1);
                System.out.println("e2 = " + e2);
                System.out.println("structural equiv: " + LambdaMatcher.structuralEquivalent(e1, e2));
                System.out.println("     alpha equiv: " + AlphaComparator.alphaEquiv(e1, e2));
            }
            catch (ParserException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private static class AlphaVisitor
    implements Lambda.VisitorRP<Boolean, Lambda> {
        private Context cl = new Context();
        private Context cr = new Context();
        private Map<String, Integer> fv = new HashMap<String, Integer>();
        private int fvId = 1;

        private AlphaVisitor() {
        }

        public void initialize() {
            this.cl.clear();
            this.cr.clear();
            this.fv.clear();
            this.fvId = 1;
        }

        @Override
        public Boolean visit(ASTAbstract abs, Lambda lambda) {
            if (lambda instanceof ASTAbstract) {
                ASTAbstract abs2 = (ASTAbstract)lambda;
                this.push(abs.name, abs2.name);
                boolean ret = abs.e.accept(this, abs2.e);
                this.pop();
                return ret;
            }
            return false;
        }

        @Override
        public Boolean visit(ASTApply app1, Lambda lambda) {
            if (lambda instanceof ASTApply) {
                ASTApply app2 = (ASTApply)lambda;
                if (app1.lexpr.accept(this, app2.lexpr).booleanValue() && app1.rexpr.accept(this, app2.rexpr).booleanValue()) {
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public Boolean visit(ASTLiteral l1, Lambda lambda) {
            if (lambda instanceof ASTLiteral) {
                ASTLiteral l2 = (ASTLiteral)lambda;
                if (this.getId(this.cl, l1.name) == this.getId(this.cr, l2.name)) {
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public Boolean visit(ASTMacro m1, Lambda lambda) {
            if (lambda instanceof ASTMacro) {
                ASTMacro m2 = (ASTMacro)lambda;
                if (this.getFreeVariableId(m1.name) == this.getFreeVariableId(m2.name)) {
                    return true;
                }
                return false;
            }
            return false;
        }

        private void push(String name1, String name2) {
            this.cl.pushVariable(name1);
            this.cr.pushVariable(name2);
        }

        private void pop() {
            this.cl.popVariable();
            this.cr.popVariable();
        }

        private int getId(Context c, String name) {
            int id = c.findVariable(name);
            if (id != -1) {
                return id;
            }
            return this.getFreeVariableId(name);
        }

        private int getFreeVariableId(String name) {
            Integer id = this.fv.get(name);
            if (id == null) {
                id = -this.fvId++;
                this.fv.put(name, id);
            }
            return id;
        }

        private static class Context {
            private LinkedList<String> names = new LinkedList();

            private Context() {
            }

            public void clear() {
                this.names.clear();
            }

            public void pushVariable(String name) {
                this.names.push(name);
            }

            public void popVariable() {
                this.names.pop();
            }

            public int findVariable(String name) {
                Iterator it = this.names.iterator();
                int i = 0;
                while (it.hasNext()) {
                    if (((String)it.next()).equals(name)) {
                        return i + 1;
                    }
                    ++i;
                }
                return -1;
            }
        }
    }
}

