/*
 * Decompiled with CFR 0.152.
 */
package extgui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;

public class LineEditor
extends JTextField {
    private List<String> histories = new ArrayList<String>();
    private List<String> working = new ArrayList<String>();
    private int limit;
    private int pos;

    public LineEditor() {
        this(32);
    }

    public LineEditor(int limit) {
        this.limit = limit;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    LineEditor.this.up();
                } else if (e.getKeyCode() == 40) {
                    LineEditor.this.down();
                }
            }
        });
        this.initWorking();
    }

    public void saveHistory() {
        String text = this.getText();
        if (!text.isEmpty()) {
            this.histories.add(0, text);
            if (this.histories.size() >= this.limit) {
                this.histories.remove(this.histories.size() - 1);
            }
        }
        this.initWorking();
    }

    private void initWorking() {
        this.working = new ArrayList<String>(this.histories);
        this.working.add(0, "");
        this.pos = 0;
    }

    private void up() {
        if (this.pos + 1 < this.working.size()) {
            this.saveText();
            ++this.pos;
            this.setText(this.working.get(this.pos));
        }
    }

    private void down() {
        if (this.pos - 1 >= 0) {
            this.saveText();
            --this.pos;
            this.setText(this.working.get(this.pos));
        }
    }

    private void saveText() {
        this.working.set(this.pos, this.getText());
    }
}

