/*
 * Decompiled with CFR 0.152.
 */
package lambda.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class Message {
    private static Message instance;
    private String language;
    private Map<String, String> messages = new HashMap<String, String>();

    private Message(String string) {
        this.language = string;
    }

    public String getLanguage() {
        return this.language;
    }

    public String get(String string) {
        return String.valueOf(this.messages.get(string));
    }

    public static Message getInstance(String string) {
        if (instance == null || instance.getLanguage().equals(string)) {
            instance = Message.load(string);
        }
        return instance;
    }

    private static Message load(String string) {
        if (string.equals("ja") || string.equals("en")) {
            return Message.loadFromResource(string);
        }
        return null;
    }

    private static Message loadFromResource(String string) {
        Message message = new Message(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Message.class.getResourceAsStream(string + ".txt")));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("\\s*=\\s*");
                if (stringArray.length != 2) continue;
                String string3 = stringArray[0].trim();
                String string4 = stringArray[1].trim();
                message.messages.put(string3, string4);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return message;
    }
}

