/*
 * Decompiled with CFR 0.152.
 */
package lambda.reduction;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.ast.VariableCollector;

public class RedexFinder {
    private static VisitorImpl visitor;
    private static LOVisitor loVisitor;

    public static IRedexNode getLeftMostOuterMostRedex(Lambda lambda, boolean bl) {
        if (loVisitor == null) {
            loVisitor = new LOVisitor();
        }
        loVisitor.etaEnabled = bl;
        return lambda.accept(loVisitor);
    }

    public static boolean isNormalForm(Lambda lambda, boolean bl) {
        return RedexFinder.getLeftMostOuterMostRedex(lambda, bl) == null;
    }

    public static List<IRedexNode> getRedexList(Lambda lambda) {
        return RedexFinder.getRedexList(lambda, false);
    }

    public static List<IRedexNode> getRedexList(Lambda lambda, boolean bl) {
        if (visitor == null) {
            visitor = new VisitorImpl();
        }
        visitor.etaEnabled = bl;
        ArrayList<IRedexNode> arrayList = new ArrayList<IRedexNode>();
        lambda.accept(visitor, arrayList);
        return arrayList;
    }

    private static boolean isBetaRedex(ASTApply aSTApply) {
        return aSTApply.lexpr.isAbstraction();
    }

    private static boolean isEtaRedex(ASTAbstract aSTAbstract) {
        if (aSTAbstract.e.isApplication()) {
            ASTApply aSTApply = (ASTApply)aSTAbstract.e;
            if (aSTApply.rexpr.isLiteral()) {
                VariableCollector variableCollector;
                Set<String> set;
                ASTLiteral aSTLiteral = (ASTLiteral)aSTApply.rexpr;
                if (aSTAbstract.name.equals(aSTLiteral.name) && !(set = (variableCollector = new VariableCollector(aSTApply.lexpr)).getFreeVariables()).contains(aSTLiteral.name)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static class LOVisitor
    implements Lambda.VisitorR<IRedexNode> {
        private boolean etaEnabled;

        private LOVisitor() {
        }

        @Override
        public IRedexNode visit(ASTAbstract aSTAbstract) {
            if (this.etaEnabled && RedexFinder.isEtaRedex(aSTAbstract)) {
                return aSTAbstract;
            }
            return aSTAbstract.e.accept(this);
        }

        @Override
        public IRedexNode visit(ASTApply aSTApply) {
            if (RedexFinder.isBetaRedex(aSTApply)) {
                return aSTApply;
            }
            IRedexNode iRedexNode = aSTApply.lexpr.accept(this);
            if (iRedexNode == null) {
                iRedexNode = aSTApply.rexpr.accept(this);
            }
            return iRedexNode;
        }

        @Override
        public IRedexNode visit(ASTLiteral aSTLiteral) {
            return null;
        }

        @Override
        public IRedexNode visit(ASTMacro aSTMacro) {
            return aSTMacro;
        }
    }

    private static class VisitorImpl
    implements Lambda.VisitorP<List<IRedexNode>> {
        private boolean etaEnabled;

        private VisitorImpl() {
        }

        @Override
        public void visit(ASTAbstract aSTAbstract, List<IRedexNode> list) {
            if (this.etaEnabled && RedexFinder.isEtaRedex(aSTAbstract)) {
                list.add(aSTAbstract);
            }
            aSTAbstract.e.accept(this, list);
        }

        @Override
        public void visit(ASTApply aSTApply, List<IRedexNode> list) {
            if (RedexFinder.isBetaRedex(aSTApply)) {
                list.add(aSTApply);
            }
            aSTApply.lexpr.accept(this, list);
            aSTApply.rexpr.accept(this, list);
        }

        @Override
        public void visit(ASTLiteral aSTLiteral, List<IRedexNode> list) {
        }

        @Override
        public void visit(ASTMacro aSTMacro, List<IRedexNode> list) {
            list.add(aSTMacro);
        }
    }
}

