/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lambda.Environment;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.gui.lambdalabel.LambdaLabel;
import lambda.gui.lambdalabel.LambdaLabelBuilder;
import lambda.gui.lambdalabel.LambdaLabelDrawer;
import lambda.gui.lambdalabel.LambdaLabelMetrics;
import lambda.reduction.RedexFinder;
import util.Pair;

public class RedexView
extends JPanel {
    private static final Color HOVER_BACK_COLOR = new Color(255, 255, 200);
    private static final Color TRIANGLE_COLOR = new Color(192, 192, 255);
    private LambdaLabelBuilder builder = new LambdaLabelBuilder();
    private List<Pair<IRedexNode, LambdaLabel>> labels = new ArrayList<Pair<IRedexNode, LambdaLabel>>();
    private Insets margin = new Insets(0, 0, 0, 0);
    private int height = -1;
    private int maxWidth;
    private int hoverIndex = -1;
    private int selectedIndex = -1;

    public RedexView() {
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.height = this.getFontMetrics(font).getHeight();
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.margin.set(n, n2, n3, n4);
        this.calcPreferredSize();
    }

    public void clearLabels() {
        this.labels.clear();
        this.maxWidth = 0;
        this.hoverIndex = -1;
        this.selectedIndex = -1;
    }

    private void addLabel(IRedexNode iRedexNode, LambdaLabel lambdaLabel) {
        this.labels.add(Pair.of(iRedexNode, lambdaLabel));
        this.calcPreferredSize();
    }

    private void calcPreferredSize() {
        Graphics graphics = this.getGraphics();
        this.maxWidth = 0;
        for (Pair<IRedexNode, LambdaLabel> pair : this.labels) {
            this.maxWidth = Math.max(this.maxWidth, LambdaLabelMetrics.getWidth(graphics, (LambdaLabel)pair._2));
        }
        int n = this.maxWidth + this.height / 2 + this.margin.left + this.margin.right;
        int n2 = this.height * this.labels.size() + this.margin.top + this.margin.bottom;
        this.setPreferredSize(new Dimension(n, n2));
    }

    public void setRedexes(Lambda lambda) {
        this.clearLabels();
        for (IRedexNode iRedexNode : RedexFinder.getRedexList(lambda, Environment.getEnvironment().getBoolean("eta_reduction"))) {
            LambdaLabel lambdaLabel = this.builder.createLambdaLabel(lambda, iRedexNode);
            this.addLabel(iRedexNode, lambdaLabel);
        }
        this.setSelectedIndex(0);
    }

    public IRedexNode getSelectedRedex() {
        int n = this.getSelectedIndex();
        if (0 <= n && n < this.labels.size()) {
            return (IRedexNode)this.labels.get((int)n)._1;
        }
        return null;
    }

    public int getLabelCount() {
        return this.labels.size();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        if (0 <= n && n < this.labels.size()) {
            this.selectedIndex = n;
            this.repaint();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    private void dispatchActionEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "selected");
        for (ActionListener actionListener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.labels.isEmpty()) {
            String string = "No Redexes";
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.stringWidth(string);
            int n2 = fontMetrics.getHeight();
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.drawString(string, (this.getWidth() - n) / 2, (this.getHeight() - n2) / 2 + fontMetrics.getLeading() + fontMetrics.getAscent());
            return;
        }
        graphics.translate(this.margin.left, this.margin.top);
        int n = this.getWidth() - (this.margin.left + this.margin.right);
        if (this.hoverIndex != -1) {
            graphics.setColor(HOVER_BACK_COLOR);
            graphics.fillRect(this.height / 2, this.hoverIndex * this.height, n - this.height / 2, this.height);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.translate(this.height / 2, 0);
        LambdaLabelDrawer lambdaLabelDrawer = new LambdaLabelDrawer();
        for (int i = 0; i < this.labels.size(); ++i) {
            Pair<IRedexNode, LambdaLabel> pair = this.labels.get(i);
            lambdaLabelDrawer.draw(graphics, (LambdaLabel)pair._2, 0, i * this.height, this.height);
        }
        graphics.translate(-this.height / 2, 0);
        if (this.selectedIndex != -1) {
            graphics.setColor(TRIANGLE_COLOR);
            this.drawTriangle(graphics, 0, this.selectedIndex * this.height + this.height / 2);
        }
        graphics.translate(-this.margin.left, -this.margin.top);
    }

    private void drawTriangle(Graphics graphics, int n, int n2) {
        int n3 = Math.max(this.height / 3, 1);
        graphics.translate(n, n2);
        graphics.fillPolygon(new int[]{0, n3, 0}, new int[]{-n3, 0, n3}, 3);
        graphics.translate(-n, -n2);
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.updateHoverIndex(mouseEvent);
            RedexView.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            RedexView.this.hoverIndex = -1;
            RedexView.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.updateHoverIndex(mouseEvent);
                if (RedexView.this.hoverIndex != -1) {
                    RedexView.this.selectedIndex = RedexView.this.hoverIndex;
                }
                RedexView.this.repaint();
                if (mouseEvent.getClickCount() >= 2) {
                    RedexView.this.dispatchActionEvent();
                }
            }
        }

        private void updateHoverIndex(MouseEvent mouseEvent) {
            RedexView.this.hoverIndex = (mouseEvent.getY() - ((RedexView)RedexView.this).margin.top) / RedexView.this.height;
            if (RedexView.this.hoverIndex < 0 || RedexView.this.labels.size() <= RedexView.this.hoverIndex) {
                RedexView.this.hoverIndex = -1;
            }
        }
    }
}

