/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import lambda.macro.MacroDefinition;

public class MacroExpander
implements Lambda.VisitorR<Lambda> {
    private MacroDefinition macroDef;
    private boolean recursive;
    private boolean unexpanded;

    public MacroExpander(MacroDefinition macroDefinition) {
        this.macroDef = macroDefinition;
    }

    public Lambda expand(Lambda lambda) {
        return this.expand(lambda, false);
    }

    public Lambda expand(Lambda lambda, boolean bl) {
        this.recursive = bl;
        this.unexpanded = false;
        return lambda.accept(this);
    }

    public boolean isSucceeded() {
        return !this.unexpanded;
    }

    @Override
    public Lambda visit(ASTAbstract aSTAbstract) {
        Lambda lambda = aSTAbstract.e.accept(this);
        return lambda == aSTAbstract.e ? aSTAbstract : new ASTAbstract(aSTAbstract.originalName, aSTAbstract.name, lambda);
    }

    @Override
    public Lambda visit(ASTApply aSTApply) {
        Lambda lambda = aSTApply.lexpr.accept(this);
        Lambda lambda2 = aSTApply.rexpr.accept(this);
        return lambda == aSTApply.lexpr && lambda2 == aSTApply.rexpr ? aSTApply : new ASTApply(lambda, lambda2);
    }

    @Override
    public Lambda visit(ASTLiteral aSTLiteral) {
        return aSTLiteral;
    }

    @Override
    public Lambda visit(ASTMacro aSTMacro) {
        Lambda lambda = this.macroDef.expandMacro(aSTMacro.name);
        if (lambda != null) {
            return this.recursive ? lambda.accept(this) : lambda;
        }
        System.out.println("- <" + aSTMacro.name + "> is undefined");
        this.unexpanded = true;
        return aSTMacro;
    }
}

