/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.HashSet;
import java.util.Set;
import lambda.ast.IDContext;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.ast.RenameGenerator;
import lambda.ast.VariableCollector;

public class ASTAbstract
extends Lambda
implements IRedexNode {
    public final String originalName;
    public final String name;
    public final Lambda e;

    public ASTAbstract(String string, String string2, Lambda lambda) {
        this.originalName = string;
        this.name = string2;
        this.e = lambda;
    }

    @Override
    public ASTAbstract deepCopy() {
        return new ASTAbstract(this.originalName, this.name, this.e.deepCopy());
    }

    @Override
    public boolean isAbstraction() {
        return true;
    }

    public Lambda apply(IDContext iDContext, Lambda lambda) {
        IDContext iDContext2 = IDContext.deriveContext(iDContext);
        iDContext2.addBoundedName(this.name);
        Lambda lambda2 = this.e.substitute(iDContext2, this.name, lambda);
        return lambda2;
    }

    @Override
    protected Lambda substitute(IDContext iDContext, String string, Lambda lambda) {
        if (this.name.equals(string)) {
            return this;
        }
        VariableCollector variableCollector = new VariableCollector(lambda);
        Set<String> set = variableCollector.getFreeVariables();
        ASTAbstract aSTAbstract = this;
        if (!set.isEmpty()) {
            aSTAbstract = this.rename(iDContext, set);
        }
        IDContext iDContext2 = IDContext.deriveContext(iDContext);
        iDContext2.addBoundedName(aSTAbstract.name);
        Lambda lambda2 = aSTAbstract.e.substitute(iDContext2, string, lambda);
        return aSTAbstract == this && lambda2 == this.e ? this : new ASTAbstract(this.originalName, aSTAbstract.name, lambda2);
    }

    private ASTAbstract rename(IDContext iDContext, Set<String> set) {
        VariableCollector variableCollector = new VariableCollector(this);
        RenameGenerator renameGenerator = new RenameGenerator(set);
        HashSet<String> hashSet = new HashSet<String>(iDContext.getBoundedNames());
        hashSet.addAll(variableCollector.getBoundedVariables());
        return (ASTAbstract)renameGenerator.rename(hashSet, this);
    }

    @Override
    public void accept(Lambda.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <TParam> void accept(Lambda.VisitorP<TParam> visitorP, TParam TParam) {
        visitorP.visit(this, TParam);
    }

    @Override
    public <TRet> TRet accept(Lambda.VisitorR<TRet> visitorR) {
        return visitorR.visit(this);
    }

    @Override
    public <TRet, TParam> TRet accept(Lambda.VisitorRP<TRet, TParam> visitorRP, TParam TParam) {
        return visitorRP.visit(this, TParam);
    }
}

