/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;

public class LaTeXStringBuilder {
    private static VisitorImpl visitor = new VisitorImpl();

    public String build(Lambda lambda) {
        return this.build(lambda, null);
    }

    public String build(Lambda lambda, IRedexNode iRedexNode) {
        visitor.redex = iRedexNode;
        return lambda.accept(visitor);
    }

    private static class VisitorImpl
    implements Lambda.VisitorR<String> {
        private IRedexNode redex;

        private VisitorImpl() {
        }

        @Override
        public String visit(ASTAbstract aSTAbstract) {
            ASTAbstract aSTAbstract2;
            String string = "\\lambda{";
            Lambda lambda = aSTAbstract;
            do {
                aSTAbstract2 = lambda;
                string = string + aSTAbstract2.name;
            } while ((lambda = aSTAbstract2.e).isAbstraction() && lambda != this.redex);
            string = string + "}.";
            string = string + lambda.accept(this);
            if (aSTAbstract == this.redex) {
                string = VisitorImpl.addUnderline(string);
            }
            return string;
        }

        @Override
        public String visit(ASTApply aSTApply) {
            Lambda lambda = aSTApply.lexpr;
            Lambda lambda2 = aSTApply.rexpr;
            boolean bl = lambda.isAbstraction();
            boolean bl2 = lambda2.isAbstraction() || lambda2.isApplication();
            String string = lambda.accept(this);
            if (bl) {
                string = "(" + string + ")";
            }
            String string2 = lambda2.accept(this);
            if (bl2) {
                string2 = "(" + string2 + ")";
            }
            if (aSTApply == this.redex) {
                string = VisitorImpl.addUnderline(string);
                string2 = VisitorImpl.addUnderline(string2);
            }
            return string + "\\," + string2;
        }

        @Override
        public String visit(ASTLiteral aSTLiteral) {
            return aSTLiteral.name;
        }

        @Override
        public String visit(ASTMacro aSTMacro) {
            String string = "\\overline{\\rm\\bf\\strut " + aSTMacro.name + "}";
            if (aSTMacro == this.redex) {
                string = VisitorImpl.addUnderline(string);
            }
            return string;
        }

        private static String addUnderline(String string) {
            return "\\underline{\\strut " + string + "}";
        }
    }
}

