/*
 * Decompiled with CFR 0.152.
 */
package lambda.reductiongraph.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import lambda.ast.Lambda;
import lambda.gui.util.GUIUtils;
import lambda.reductiongraph.StateSearcher;
import lambda.reductiongraph.event.SearchEndListener;
import lambda.reductiongraph.gui.DirectedGraphPanel;

public class ReductionGraphView
extends JPanel {
    private DirectedGraphPanel graphPanel;
    private JButton buttonStart;
    private JButton buttonStop;
    private JSpinner spinnerMaxDepth;
    private StateSearcher searcher;
    private int storedNodeCount;

    public ReductionGraphView() {
        this.setLayout(new BorderLayout());
        this.graphPanel = new DirectedGraphPanel();
        this.add((Component)this.graphPanel, "Center");
        this.buttonStart = new JButton("start");
        this.buttonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReductionGraphView.this.dispathActionEvent();
            }
        });
        this.buttonStop = new JButton("stop");
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ReductionGraphView.this.searcher != null) {
                    ReductionGraphView.this.searcher.abort();
                }
            }
        });
        this.buttonStop.setEnabled(false);
        this.spinnerMaxDepth = new JSpinner(new SpinnerNumberModel(20, 1, 100, 1));
        final JCheckBox jCheckBox = new JCheckBox("antialias");
        jCheckBox.setSelected(false);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReductionGraphView.this.graphPanel.setAntialias(jCheckBox.isSelected());
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox("curve");
        jCheckBox2.setSelected(true);
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReductionGraphView.this.graphPanel.setDrawCurve(jCheckBox2.isSelected());
            }
        });
        final JCheckBox jCheckBox3 = new JCheckBox("multi-edge");
        jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReductionGraphView.this.graphPanel.setMultipleEdges(jCheckBox3.isSelected());
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.buttonStart);
        jPanel.add(this.buttonStop);
        jPanel.add(new JLabel("max depth:"));
        jPanel.add(this.spinnerMaxDepth);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jCheckBox);
        jPanel2.add(jCheckBox2);
        jPanel2.add(jCheckBox3);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        GUIUtils.setVerticalLayout(jPanel3, false, false);
        this.add((Component)jPanel3, "South");
    }

    public int getStoredNodeCount() {
        return this.storedNodeCount;
    }

    public void setStartButtonEnabled(boolean bl) {
        this.buttonStart.setEnabled(bl);
    }

    public void setStopButtonEnabled(boolean bl) {
        this.buttonStop.setEnabled(bl);
    }

    public void startSearch(Lambda lambda) {
        this.buttonStart.setEnabled(false);
        this.buttonStop.setEnabled(true);
        this.graphPanel.clearGraph();
        int n = (Integer)this.spinnerMaxDepth.getValue();
        this.searcher = new StateSearcher(this.graphPanel, lambda, n);
        this.searcher.addSearchEndListener(new SearchEndListener(){

            @Override
            public void searchEnded() {
                ReductionGraphView.this.storedNodeCount = ReductionGraphView.this.searcher.getStateCount();
                ReductionGraphView.this.dispathSearchEndEvent();
                ReductionGraphView.this.buttonStart.setEnabled(true);
                ReductionGraphView.this.buttonStop.setEnabled(false);
                ReductionGraphView.this.searcher = null;
            }
        });
        this.searcher.startSearch();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    private void dispathActionEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "start");
        for (ActionListener actionListener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void addSearchEndListener(SearchEndListener searchEndListener) {
        this.listenerList.add(SearchEndListener.class, searchEndListener);
    }

    public void removeSearchEndListener(SearchEndListener searchEndListener) {
        this.listenerList.remove(SearchEndListener.class, searchEndListener);
    }

    private void dispathSearchEndEvent() {
        for (SearchEndListener searchEndListener : (SearchEndListener[])this.listenerList.getListeners(SearchEndListener.class)) {
            searchEndListener.searchEnded();
        }
    }
}

