/*
 * Decompiled with CFR 0.152.
 */
package lambda.reductiongraph.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;

public class GraphNode {
    private static final Color INITIAL_COLOR = new Color(100, 100, 255);
    private static final Color ACCEPT_COLOR = new Color(255, 100, 100);
    private static final Color INFINITY_COLOR = new Color(200, 200, 200);
    private static final Color NODE_COLOR = new Color(100, 255, 100);
    public static int R = 8;
    private String label;
    private int depth = Short.MAX_VALUE;
    private Point2D.Double location = new Point2D.Double();
    private Point2D.Double destination = new Point2D.Double();
    private boolean accept;
    private boolean infinity;
    private boolean animating;

    public GraphNode(String string) {
        this.label = string;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public String getLabel() {
        return this.label;
    }

    public void setInfinity(boolean bl) {
        this.infinity = bl;
    }

    public boolean isAccept() {
        return this.accept;
    }

    public void setAccept(boolean bl) {
        this.accept = bl;
    }

    public void setLocation(int n, int n2) {
        this.location.x = n;
        this.location.y = n2;
        this.animating = true;
    }

    public void setDestination(int n, int n2) {
        this.destination.x = n;
        this.destination.y = n2;
        this.animating = true;
    }

    public void setX(int n) {
        this.destination.x = n;
        this.animating = true;
    }

    public void setY(int n) {
        this.destination.y = n;
        this.animating = true;
    }

    public int getX() {
        return (int)this.location.x;
    }

    public int getY() {
        return (int)this.location.y;
    }

    public boolean update() {
        if (this.animating) {
            this.location.x += 0.2 * (this.destination.x - this.location.x);
            this.location.y += 0.2 * (this.destination.y - this.location.y);
            if (this.location.distanceSq(this.destination) < 0.1) {
                this.location.setLocation(this.destination);
                this.animating = false;
            }
        }
        return this.animating;
    }

    public void draw(Graphics graphics, boolean bl) {
        if (this.infinity) {
            graphics.setColor(INFINITY_COLOR);
        } else if (this.isAccept()) {
            graphics.setColor(ACCEPT_COLOR);
        } else if (bl) {
            graphics.setColor(INITIAL_COLOR);
        } else {
            graphics.setColor(NODE_COLOR);
        }
        graphics.fillOval(this.getX() - R, this.getY() - R, 2 * R, 2 * R);
        if (R > 4) {
            graphics.setColor(Color.BLACK);
            graphics.drawOval(this.getX() - R, this.getY() - R, 2 * R, 2 * R);
            if (this.isAccept()) {
                int n = Math.max(R - 2, 0);
                graphics.drawOval(this.getX() - n, this.getY() - n, 2 * n, 2 * n);
            }
        }
    }
}

