/*
 * Decompiled with CFR 0.152.
 */
package lambda.reductiongraph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.macro.MacroDefinition;
import lambda.reduction.Reducer;
import lambda.reductiongraph.IStateNode;
import lambda.reductiongraph.InfinityNode;
import lambda.reductiongraph.LambdaNode;
import lambda.reductiongraph.event.SearchEndListener;
import lambda.reductiongraph.gui.DirectedGraphPanel;
import lambda.reductiongraph.gui.GraphNode;

public class StateSearcher {
    private static final MacroDefinition EMPTY_MACRO_DEF = new MacroDefinition();
    private DirectedGraphPanel graphPanel;
    private Lambda lambda;
    private int maxDepth;
    private Map<IStateNode, GraphNode> nodeMapping = new HashMap<IStateNode, GraphNode>();
    private boolean createdNew;
    private int states;
    private EventListenerList listeners = new EventListenerList();
    private Thread thread;

    public StateSearcher(DirectedGraphPanel directedGraphPanel, Lambda lambda, int n) {
        this.graphPanel = directedGraphPanel;
        this.lambda = lambda;
        this.maxDepth = n;
    }

    public int getStateCount() {
        return this.states;
    }

    public void startSearch() {
        this.thread = new SearchThread();
        this.thread.setName("SearchThread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void abort() {
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.thread = null;
        }
    }

    public void addSearchEndListener(SearchEndListener searchEndListener) {
        this.listeners.add(SearchEndListener.class, searchEndListener);
    }

    private void dispatchSearchEndEvent() {
        for (SearchEndListener searchEndListener : (SearchEndListener[])this.listeners.getListeners(SearchEndListener.class)) {
            searchEndListener.searchEnded();
        }
    }

    private void searchOnLine() throws InterruptedException {
        this.nodeMapping.clear();
        HashSet<LambdaNode> hashSet = new HashSet<LambdaNode>();
        LinkedList<LambdaNode> linkedList = new LinkedList<LambdaNode>();
        LambdaNode lambdaNode = new LambdaNode(0, this.lambda);
        GraphNode graphNode = this.addGraphNode(lambdaNode);
        this.graphPanel.setInitialNode(graphNode);
        linkedList.add(lambdaNode);
        while (!linkedList.isEmpty()) {
            LambdaNode lambdaNode2 = (LambdaNode)linkedList.poll();
            if (hashSet.contains(lambdaNode2)) continue;
            hashSet.add(lambdaNode2);
            GraphNode graphNode2 = this.addGraphNode(lambdaNode2);
            List<IRedexNode> list = lambdaNode2.getRedexes();
            if (list.isEmpty()) {
                graphNode2.setAccept(true);
            }
            for (IRedexNode iRedexNode : list) {
                GraphNode graphNode3;
                Reducer.Result result = Reducer.reduce(lambdaNode2.lambda, EMPTY_MACRO_DEF, iRedexNode);
                LambdaNode lambdaNode3 = new LambdaNode(lambdaNode2.depth + 1, result.lambda);
                if (lambdaNode3.depth <= this.maxDepth || hashSet.contains(lambdaNode3)) {
                    graphNode3 = this.addGraphNode(lambdaNode3);
                    if (lambdaNode3.getRedexes().isEmpty()) {
                        graphNode3.setAccept(true);
                    }
                    if (this.createdNew) {
                        graphNode3.setLocation(graphNode2.getX(), graphNode2.getY());
                        graphNode3.setDestination(graphNode2.getX(), graphNode2.getY());
                    }
                    linkedList.add(lambdaNode3);
                } else {
                    InfinityNode infinityNode = InfinityNode.getInstance();
                    graphNode3 = this.addGraphNode(infinityNode);
                    graphNode3.setInfinity(true);
                }
                this.graphPanel.addEdge(graphNode2, graphNode3);
            }
            Thread.sleep(50L);
        }
        this.states = hashSet.size();
    }

    private GraphNode addGraphNode(IStateNode iStateNode) {
        GraphNode graphNode = this.nodeMapping.get(iStateNode);
        if (graphNode == null) {
            graphNode = new GraphNode(iStateNode.getText());
            this.nodeMapping.put(iStateNode, graphNode);
            this.graphPanel.addNode(graphNode);
            this.createdNew = true;
        } else {
            this.createdNew = false;
        }
        return graphNode;
    }

    private class SearchThread
    extends Thread {
        private SearchThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                StateSearcher.this.searchOnLine();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                StateSearcher.this.dispatchSearchEndEvent();
            }
        }
    }
}

