/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import javax.swing.GroupLayout;
import javax.swing.UIManager;

public final class GUIUtils {
    private static String[] availableFontFamilyNames;

    public static void setVerticalLayout(Container container) {
        GUIUtils.setVerticalLayout(container, true, true);
    }

    public static void setVerticalLayout(Container container, boolean bl, boolean bl2) {
        GUIUtils.setGroupLayout(container, bl, bl2, true);
    }

    public static void setHorizontalLayout(Container container) {
        GUIUtils.setHorizontalLayout(container, true, true);
    }

    public static void setHorizontalLayout(Container container, boolean bl, boolean bl2) {
        GUIUtils.setGroupLayout(container, bl, bl2, false);
    }

    private static void setGroupLayout(Container container, boolean bl, boolean bl2, boolean bl3) {
        GroupLayout groupLayout = new GroupLayout(container);
        container.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(bl);
        groupLayout.setAutoCreateContainerGaps(bl2);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(bl3 ? GroupLayout.Alignment.LEADING : GroupLayout.Alignment.BASELINE);
        for (Component component : container.getComponents()) {
            sequentialGroup = sequentialGroup.addComponent(component);
            parallelGroup = parallelGroup.addComponent(component, 0, -2, Short.MAX_VALUE);
        }
        if (bl3) {
            groupLayout.setVerticalGroup(sequentialGroup);
            groupLayout.setHorizontalGroup(parallelGroup);
        } else {
            groupLayout.setVerticalGroup(parallelGroup);
            groupLayout.setHorizontalGroup(sequentialGroup);
        }
    }

    public static void setLookAndFeelToSystem() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void preloadFontNames() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        availableFontFamilyNames = graphicsEnvironment.getAvailableFontFamilyNames();
    }

    public static String[] getAvailableFontFamilyNames() {
        if (availableFontFamilyNames == null) {
            GUIUtils.preloadFontNames();
        }
        return availableFontFamilyNames;
    }
}

