/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.lambdalabel;

import java.awt.Color;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.gui.lambdalabel.LambdaLabel;

public class LambdaLabelBuilder {
    private static final Color COLOR_ABS = new Color(255, 240, 100, 200);
    private static final Color COLOR_APP_L = new Color(255, 200, 200, 200);
    private static final Color COLOR_APP_R = new Color(200, 200, 255, 200);
    private static final Color COLOR_MACRO = new Color(200, 255, 200, 200);
    private IRedexNode redex;
    private ConvertVisitor visitor = new ConvertVisitor();

    public LambdaLabel createLambdaLabel(Lambda lambda, IRedexNode iRedexNode) {
        this.redex = iRedexNode;
        return lambda.accept(this.visitor);
    }

    private class ConvertVisitor
    implements Lambda.VisitorR<LambdaLabel> {
        private ConvertVisitor() {
        }

        @Override
        public LambdaLabel visit(ASTAbstract aSTAbstract) {
            LambdaLabel lambdaLabel = LambdaLabel.abs(aSTAbstract.name, aSTAbstract.e.accept(this));
            if (aSTAbstract == LambdaLabelBuilder.this.redex) {
                lambdaLabel = LambdaLabel.wrap(lambdaLabel, COLOR_ABS);
            }
            return lambdaLabel;
        }

        @Override
        public LambdaLabel visit(ASTApply aSTApply) {
            LambdaLabel lambdaLabel = aSTApply.lexpr.accept(this);
            LambdaLabel lambdaLabel2 = aSTApply.rexpr.accept(this);
            if (aSTApply == LambdaLabelBuilder.this.redex) {
                lambdaLabel = LambdaLabel.wrap(lambdaLabel, COLOR_APP_L);
                lambdaLabel2 = LambdaLabel.wrap(lambdaLabel2, COLOR_APP_R);
            }
            return LambdaLabel.apply(lambdaLabel, lambdaLabel2);
        }

        @Override
        public LambdaLabel visit(ASTLiteral aSTLiteral) {
            return LambdaLabel.literal(aSTLiteral.name);
        }

        @Override
        public LambdaLabel visit(ASTMacro aSTMacro) {
            LambdaLabel lambdaLabel = LambdaLabel.macro(aSTMacro.name);
            if (aSTMacro == LambdaLabelBuilder.this.redex) {
                lambdaLabel = LambdaLabel.wrap(lambdaLabel, COLOR_MACRO);
            }
            return lambdaLabel;
        }
    }
}

