/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import lambda.Environment;
import lambda.gui.Main;
import lambda.gui.MainFrame;
import lambda.gui.fontdialog.FontDialog;
import lambda.gui.fontdialog.event.FontUpdateListener;

public class MainMenu
extends JMenuBar {
    private MainFrame owner;

    public MainMenu(MainFrame mainFrame) {
        this.owner = mainFrame;
        this.setBorder(null);
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenu jMenu = new JMenu("File");
        this.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Load Macros");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.owner.loadMacroFile();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Exit");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.owner.dispose();
            }
        });
        jMenu.add(jMenuItem2);
        JMenu jMenu2 = new JMenu("View");
        this.add(jMenu2);
        JMenuItem jMenuItem3 = new JMenuItem("Font");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final Environment environment = Environment.getEnvironment();
                String string = environment.get("gui.fontfamily", "");
                int n = environment.getInt("gui.fontsize", 12);
                int n2 = environment.getInt("gui.ui.font.addition", 0);
                FontDialog fontDialog = new FontDialog();
                fontDialog.setLocationRelativeTo(MainMenu.this.owner);
                fontDialog.setSelectedFamilyName(string);
                fontDialog.setSelectedFontSize(n);
                fontDialog.setFontAddition(n2);
                fontDialog.addFontApplyListener(new FontUpdateListener(){

                    @Override
                    public void fontFamilyChanged(String string) {
                        environment.set("gui.fontfamily", string);
                        Main.reload(environment.getGUIFont());
                    }

                    @Override
                    public void fontSizeChanged(int n) {
                        environment.set("gui.fontsize", n);
                        Main.reload(environment.getGUIFont());
                    }

                    @Override
                    public void uiFontAdditionChanged(int n) {
                        environment.set("gui.ui.font.addition", n);
                        Main.updateUIFontAddition();
                    }
                });
                if (!fontDialog.showModal()) {
                    environment.set("gui.fontfamily", string);
                    environment.set("gui.fontsize", n);
                    environment.set("gui.ui.font.addition", n2);
                    Main.reload(environment.getGUIFont());
                    Main.updateUIFontAddition();
                }
            }
        });
        jMenu2.add(jMenuItem3);
        JMenu jMenu3 = new JMenu("About");
        this.add(jMenu3);
        JMenuItem jMenuItem4 = new JMenuItem("Version");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.showVersion();
            }
        });
        jMenu3.add(jMenuItem4);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(null);
    }

    private void showVersion() {
        String string = "";
        string = string + "Lambda * Magica version 3.81\n";
        string = string + "Release Date: 2012-12-10\n";
        string = string + "Copyright (C) 2011-2012 Yuuki.S All Rights Reserved.";
        JOptionPane.showMessageDialog(this.owner, string, "Version Information", 1);
    }
}

