/*
 * Decompiled with CFR 0.152.
 */
package lambda.stategraph.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import lambda.ast.Lambda;
import lambda.gui.util.GUIUtils;
import lambda.stategraph.StateSearcher;
import lambda.stategraph.event.SearchEndListener;
import lambda.stategraph.gui.StateGraphPanel;

public class StateGraphView
extends JPanel {
    private StateGraphPanel graphPanel;
    private JButton buttonStart;
    private JButton buttonStop;
    private JSpinner spinnerMaxDepth;
    private StateSearcher searcher;

    public StateGraphView() {
        this.setLayout(new BorderLayout());
        this.graphPanel = new StateGraphPanel();
        this.add((Component)this.graphPanel, "Center");
        this.buttonStart = new JButton("start");
        this.buttonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StateGraphView.this.dispathActionEvent();
            }
        });
        this.buttonStop = new JButton("stop");
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StateGraphView.this.searcher != null) {
                    StateGraphView.this.searcher.abort();
                }
            }
        });
        this.buttonStop.setEnabled(false);
        this.spinnerMaxDepth = new JSpinner(new SpinnerNumberModel(20, 1, 100, 1));
        final JCheckBox jCheckBox = new JCheckBox("antialias");
        jCheckBox.setSelected(false);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StateGraphView.this.graphPanel.setAntialias(jCheckBox.isSelected());
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox("curve");
        jCheckBox2.setSelected(true);
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StateGraphView.this.graphPanel.setDrawCurve(jCheckBox2.isSelected());
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.buttonStart);
        jPanel.add(this.buttonStop);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("max depth:"));
        jPanel2.add(this.spinnerMaxDepth);
        jPanel2.add(jCheckBox);
        jPanel2.add(jCheckBox2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        GUIUtils.setVerticalLayout(jPanel3, false, false);
        this.add((Component)jPanel3, "South");
    }

    public void setStartButtonEnabled(boolean bl) {
        this.buttonStart.setEnabled(bl);
    }

    public void setStopButtonEnabled(boolean bl) {
        this.buttonStop.setEnabled(bl);
    }

    public void startSearch(Lambda lambda) {
        this.buttonStart.setEnabled(false);
        this.buttonStop.setEnabled(true);
        this.graphPanel.clearGraph();
        int n = (Integer)this.spinnerMaxDepth.getValue();
        this.searcher = new StateSearcher(this.graphPanel, lambda, n);
        this.searcher.addSearchEndListener(new SearchEndListener(){

            @Override
            public void searchEnded() {
                StateGraphView.this.buttonStart.setEnabled(true);
                StateGraphView.this.buttonStop.setEnabled(false);
                StateGraphView.this.searcher = null;
            }
        });
        this.searcher.startSearch();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    private void dispathActionEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "start");
        for (ActionListener actionListener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(actionEvent);
        }
    }
}

