/*
 * Decompiled with CFR 0.152.
 */
package lambda.stategraph.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import lambda.stategraph.gui.GraphNode;

public class StateGraphPanel
extends JPanel {
    private static final Color TEXT_BACK_COLOR = new Color(255, 255, 255, 220);
    private static final Stroke LINE_STROKE = new BasicStroke(0.5f, 0, 2);
    private static final Stroke EM_LINE_STROKE = new BasicStroke(1.0f, 0, 2);
    private final Object lockEdges = new Object();
    private GraphNode initialNode;
    private GraphNode hoverNode;
    private List<GraphNode> nodes = new LinkedList<GraphNode>();
    private Map<Integer, Set<GraphNode>> depthSlicedNodes = new HashMap<Integer, Set<GraphNode>>();
    private int maxDepth;
    private Map<GraphNode, Set<GraphNode>> edges = new HashMap<GraphNode, Set<GraphNode>>();
    private List<Edge> edgeLines = new ArrayList<Edge>();
    private List<Edge> inEdgeLines = new ArrayList<Edge>();
    private List<Edge> outEdgeLines = new ArrayList<Edge>();
    private boolean structureChanged;
    private boolean hoverNodeChanged;
    private boolean resized;
    private Point translation = new Point();
    private boolean antialias;
    private boolean drawCurve;
    private boolean animationSuspended;
    private double scale = 1.0;

    public StateGraphPanel() {
        MouseAdapter mouseAdapter = new MouseAdapter(){
            private Point mp;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.mp = mouseEvent.getPoint();
                StateGraphPanel.this.requestFocus();
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                StateGraphPanel.this.updateHoverNode(mouseEvent.getX() - ((StateGraphPanel)StateGraphPanel.this).translation.x, mouseEvent.getY() - ((StateGraphPanel)StateGraphPanel.this).translation.y);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX() - this.mp.x;
                int n2 = mouseEvent.getY() - this.mp.y;
                this.mp = mouseEvent.getPoint();
                ((StateGraphPanel)StateGraphPanel.this).translation.x += n;
                ((StateGraphPanel)StateGraphPanel.this).translation.y += n2;
                StateGraphPanel.this.resumeAnimation();
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = mouseWheelEvent.getWheelRotation();
                if (n >= 0) {
                    StateGraphPanel.this.scale *= 0.9;
                } else {
                    StateGraphPanel.this.scale *= 1.1;
                }
                StateGraphPanel.this.resized = true;
                StateGraphPanel.this.resumeAnimation();
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseWheelListener(mouseAdapter);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                StateGraphPanel.this.resized = true;
                StateGraphPanel.this.resumeAnimation();
            }
        });
        this.setFocusable(true);
        this.setIgnoreRepaint(true);
        this.setDrawCurve(true);
        this.setupAccelerators();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        if (StateGraphPanel.this.animationSuspended) {
                            StateGraphPanel.this.suspendAnimation();
                        }
                        StateGraphPanel.this.updateFrame();
                        StateGraphPanel.this.repaint();
                        Thread.sleep(20L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return;
                }
            }
        };
        thread.setName("AnimationThread");
        thread.setDaemon(true);
        thread.start();
    }

    public void setAntialias(boolean bl) {
        this.antialias = bl;
        this.resumeAnimation();
    }

    public void setDrawCurve(boolean bl) {
        this.drawCurve = bl;
        this.resumeAnimation();
    }

    private void setupAccelerators() {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(45, n), "min");
        inputMap.put(KeyStroke.getKeyStroke(109, n), "min");
        inputMap.put(KeyStroke.getKeyStroke(107, n), "mag");
        inputMap.put(KeyStroke.getKeyStroke(521, n), "mag");
        inputMap.put(KeyStroke.getKeyStroke(59, n), "mag");
        inputMap.put(KeyStroke.getKeyStroke(48, n), "reset");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("min", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StateGraphPanel.this.minifyNodeSize();
            }
        });
        actionMap.put("mag", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StateGraphPanel.this.magnifyNodeSize();
            }
        });
        actionMap.put("reset", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StateGraphPanel.this.resetAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendAnimation() {
        try {
            StateGraphPanel stateGraphPanel = this;
            synchronized (stateGraphPanel) {
                while (this.animationSuspended) {
                    this.notifyAll();
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeAnimation() {
        StateGraphPanel stateGraphPanel = this;
        synchronized (stateGraphPanel) {
            this.animationSuspended = false;
            this.notifyAll();
        }
    }

    public void magnifyNodeSize() {
        ++GraphNode.R;
        this.resumeAnimation();
    }

    public void minifyNodeSize() {
        GraphNode.R = Math.max(GraphNode.R - 1, 0);
        this.resumeAnimation();
    }

    public void resetAll() {
        GraphNode.R = 8;
        this.translation.setLocation(0, 0);
        this.scale = 1.0;
        this.resized = true;
        this.resumeAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(GraphNode graphNode) {
        List<GraphNode> list = this.nodes;
        synchronized (list) {
            this.nodes.add(graphNode);
            this.structureChanged = true;
        }
        this.resumeAnimation();
    }

    public void setInitialNode(GraphNode graphNode) {
        this.initialNode = graphNode;
        this.resumeAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEdge(GraphNode graphNode, GraphNode graphNode2) {
        Object object = this.lockEdges;
        synchronized (object) {
            Set<GraphNode> set = this.edges.get(graphNode);
            if (set == null) {
                set = new HashSet<GraphNode>();
                this.edges.put(graphNode, set);
            }
            set.add(graphNode2);
            this.structureChanged = true;
            this.resumeAnimation();
        }
    }

    public void addEdges(GraphNode graphNode, GraphNode ... graphNodeArray) {
        for (GraphNode graphNode2 : graphNodeArray) {
            this.addEdge(graphNode, graphNode2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGraph() {
        Object object = this.nodes;
        synchronized (object) {
            this.nodes.clear();
        }
        this.setInitialNode(null);
        this.setHoverNode(null);
        object = this.lockEdges;
        synchronized (object) {
            this.edges.clear();
            this.edgeLines.clear();
            this.inEdgeLines.clear();
            this.outEdgeLines.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHoverNode(int n, int n2) {
        GraphNode graphNode = null;
        List<GraphNode> list = this.nodes;
        synchronized (list) {
            for (GraphNode graphNode2 : this.nodes) {
                int n3;
                int n4 = graphNode2.getX();
                if ((n4 - n) * (n4 - n) + ((n3 = graphNode2.getY()) - n2) * (n3 - n2) > GraphNode.R * GraphNode.R) continue;
                graphNode = graphNode2;
                break;
            }
        }
        this.setHoverNode(graphNode);
    }

    private synchronized void setHoverNode(GraphNode graphNode) {
        if (this.hoverNode != graphNode) {
            this.hoverNode = graphNode;
            this.hoverNodeChanged = true;
            this.resumeAnimation();
        }
    }

    private synchronized GraphNode getHoverNode() {
        return this.hoverNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layoutNodes() {
        if (this.initialNode == null) {
            return;
        }
        this.depthSlicedNodes.clear();
        HashSet<GraphNode> hashSet = new HashSet<GraphNode>();
        LinkedList<GraphNode> linkedList = new LinkedList<GraphNode>();
        this.initialNode.setDepth(0);
        linkedList.add(this.initialNode);
        this.maxDepth = 0;
        while (!linkedList.isEmpty()) {
            Set<GraphNode> set;
            GraphNode graphNode = (GraphNode)linkedList.poll();
            if (hashSet.contains(graphNode)) continue;
            hashSet.add(graphNode);
            this.maxDepth = Math.max(graphNode.getDepth(), this.maxDepth);
            Set<GraphNode> set2 = this.depthSlicedNodes.get(graphNode.getDepth());
            if (set2 == null) {
                set2 = new HashSet<GraphNode>();
                this.depthSlicedNodes.put(graphNode.getDepth(), set2);
            }
            set2.add(graphNode);
            Iterator<GraphNode> iterator = this.lockEdges;
            synchronized (iterator) {
                set = this.edges.get(graphNode);
            }
            if (set == null) continue;
            for (GraphNode graphNode2 : set) {
                if (hashSet.contains(graphNode2)) continue;
                graphNode2.setDepth(Math.min(graphNode2.getDepth(), graphNode.getDepth() + 1));
                linkedList.add(graphNode2);
            }
        }
    }

    private void updateNodeLocation() {
        double d = this.scale * (double)this.getWidth();
        double d2 = this.scale * (double)this.getHeight();
        for (Map.Entry<Integer, Set<GraphNode>> entry : this.depthSlicedNodes.entrySet()) {
            Set<GraphNode> set = entry.getValue();
            int n = set.size();
            int n2 = 0;
            int n3 = entry.getKey();
            int n4 = (int)(((double)this.getHeight() - d2) / 2.0 + d2 * (double)(n3 + 1) / (double)(this.maxDepth + 2));
            for (GraphNode graphNode : set) {
                int n5 = (int)(((double)this.getWidth() - d) / 2.0 + d * (double)(++n2) / (double)(n + 1));
                graphNode.setDestination(n5, n4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEdgeLines() {
        GraphNode graphNode = this.getHoverNode();
        Object object = this.lockEdges;
        synchronized (object) {
            this.edgeLines.clear();
            this.outEdgeLines.clear();
            this.inEdgeLines.clear();
            for (Map.Entry<GraphNode, Set<GraphNode>> entry : this.edges.entrySet()) {
                GraphNode graphNode2 = entry.getKey();
                for (GraphNode graphNode3 : entry.getValue()) {
                    Edge edge = new Edge(graphNode2, graphNode3);
                    if (graphNode2 == graphNode) {
                        this.outEdgeLines.add(edge);
                        continue;
                    }
                    if (graphNode3 == graphNode) {
                        this.inEdgeLines.add(edge);
                        continue;
                    }
                    this.edgeLines.add(edge);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrame() {
        boolean bl = false;
        List<GraphNode> list = this.nodes;
        synchronized (list) {
            for (GraphNode graphNode : this.nodes) {
                bl = graphNode.update() || bl;
            }
        }
        if (this.structureChanged || this.resized) {
            this.layoutNodes();
        }
        this.updateNodeLocation();
        list = this.nodes;
        synchronized (list) {
            Collections.sort(this.nodes, NodeLocationComparator.getInstance());
        }
        if (this.hoverNodeChanged || this.structureChanged) {
            this.updateEdgeLines();
        }
        if (!(bl || this.structureChanged || this.hoverNodeChanged || this.resized)) {
            this.animationSuspended = true;
        }
        this.resized = false;
        this.structureChanged = false;
        this.hoverNodeChanged = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(Graphics2D graphics2D) {
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n = this.translation.x;
        int n2 = this.translation.y;
        graphics2D.translate(n, n2);
        if (this.antialias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics2D.setStroke(LINE_STROKE);
        Object object = this.lockEdges;
        synchronized (object) {
            graphics2D.setColor(Color.LIGHT_GRAY);
            this.drawEdges(graphics2D, this.edgeLines);
        }
        object = this.nodes;
        synchronized (object) {
            for (GraphNode graphNode : this.nodes) {
                graphNode.draw(graphics2D, graphNode == this.initialNode);
            }
        }
        graphics2D.setStroke(EM_LINE_STROKE);
        object = this.lockEdges;
        synchronized (object) {
            graphics2D.setColor(Color.BLUE);
            this.drawEdges(graphics2D, this.inEdgeLines);
            graphics2D.setColor(Color.RED);
            this.drawEdges(graphics2D, this.outEdgeLines);
        }
        object = this.getHoverNode();
        if (object != null) {
            graphics2D.setColor(TEXT_BACK_COLOR);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n3 = fontMetrics.stringWidth(((GraphNode)object).getLabel());
            int n4 = fontMetrics.getHeight();
            graphics2D.fillRect(((GraphNode)object).getX() + 20, ((GraphNode)object).getY() - 8 - n4 + fontMetrics.getDescent(), n3, n4);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(((GraphNode)object).getLabel(), ((GraphNode)object).getX() + 20, ((GraphNode)object).getY() - 8);
        }
        if (this.antialias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
        graphics2D.translate(-n, -n2);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.render((Graphics2D)graphics);
    }

    private void drawEdges(Graphics2D graphics2D, List<Edge> list) {
        for (Edge edge : list) {
            GraphNode graphNode = edge.p;
            GraphNode graphNode2 = edge.q;
            if (graphNode == graphNode2) {
                StateGraphPanel.drawSelfCyclicEdge(graphics2D, graphNode.getX(), graphNode.getY());
                continue;
            }
            if (this.drawCurve) {
                StateGraphPanel.drawCurveEdge(graphics2D, graphNode.getX(), graphNode.getY(), graphNode2.getX(), graphNode2.getY());
                continue;
            }
            StateGraphPanel.drawStraightEdge(graphics2D, graphNode.getX(), graphNode.getY(), graphNode2.getX(), graphNode2.getY());
        }
    }

    private static void drawCurveEdge(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        double d = Math.atan2(n4 - n2, n3 - n) - 1.5707963267948966;
        int n5 = 30;
        double d2 = (double)(n + n3) / 2.0 + (double)n5 * Math.cos(d);
        double d3 = (double)(n2 + n4) / 2.0 + (double)n5 * Math.sin(d);
        double d4 = Math.atan2(d3 - (double)n2, d2 - (double)n);
        double d5 = Math.atan2((double)n4 - d3, (double)n3 - d2);
        int n6 = GraphNode.R + 1;
        double d6 = (double)n6 * Math.cos(d4);
        double d7 = (double)n6 * Math.sin(d4);
        double d8 = (double)n6 * Math.cos(d5);
        double d9 = (double)n6 * Math.sin(d5);
        double d10 = (double)n + d6;
        double d11 = (double)n2 + d7;
        double d12 = (double)n3 - d8;
        double d13 = (double)n4 - d9;
        QuadCurve2D.Double double_ = new QuadCurve2D.Double(d10, d11, d2, d3, d12, d13);
        graphics2D.draw(double_);
        StateGraphPanel.drawTriangle(graphics2D, d12, d13, d5);
    }

    private static void drawStraightEdge(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        double d = Math.atan2(n4 - n2, n3 - n);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = 10.0;
        double d5 = (double)n + d4 * d2;
        double d6 = (double)n2 + d4 * d3;
        double d7 = (double)n3 - d4 * d2;
        double d8 = (double)n4 - d4 * d3;
        graphics2D.drawLine((int)d5, (int)d6, (int)d7, (int)d8);
        StateGraphPanel.drawTriangle(graphics2D, d7, d8, d);
    }

    private static void drawSelfCyclicEdge(Graphics2D graphics2D, int n, int n2) {
        int n3 = GraphNode.R;
        double d = n;
        double d2 = n2 - n3;
        double d3 = n + 4 * n3;
        double d4 = n2 - 8 * n3;
        double d5 = n + 4 * n3;
        double d6 = n2 + 8 * n3;
        double d7 = n;
        double d8 = n2 + n3;
        CubicCurve2D.Double double_ = new CubicCurve2D.Double(d, d2, d3, d4, d5, d6, d7, d8);
        graphics2D.draw(double_);
        double d9 = Math.atan2(d8 - d6, d7 - d5);
        StateGraphPanel.drawTriangle(graphics2D, n, n2 + n3, d9);
    }

    private static void drawTriangle(Graphics graphics, double d, double d2, double d3) {
        int n = 6;
        Polygon polygon = new Polygon();
        polygon.addPoint((int)d, (int)d2);
        polygon.addPoint((int)(d - (double)n * Math.cos(d3 + 0.5235987755982988)), (int)(d2 - (double)n * Math.sin(d3 + 0.5235987755982988)));
        polygon.addPoint((int)(d - (double)n * Math.cos(d3 - 0.5235987755982988)), (int)(d2 - (double)n * Math.sin(d3 - 0.5235987755982988)));
        graphics.fillPolygon(polygon);
    }

    private static class NodeLocationComparator
    implements Comparator<GraphNode> {
        private static NodeLocationComparator instance;

        private NodeLocationComparator() {
        }

        @Override
        public int compare(GraphNode graphNode, GraphNode graphNode2) {
            if (graphNode.getDepth() == graphNode2.getDepth()) {
                return Double.compare(graphNode.getX(), graphNode2.getX());
            }
            return graphNode.getDepth() < graphNode2.getDepth() ? -1 : 1;
        }

        public static Comparator<GraphNode> getInstance() {
            return instance == null ? (instance = new NodeLocationComparator()) : instance;
        }
    }

    private static class Edge {
        public final GraphNode p;
        public final GraphNode q;

        public Edge(GraphNode graphNode, GraphNode graphNode2) {
            this.p = graphNode;
            this.q = graphNode2;
        }
    }
}

