/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.lambdalabel;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import lambda.gui.lambdalabel.LambdaLabel;
import lambda.gui.lambdalabel.LambdaLabelMetrics;

public class LambdaLabelDrawer
implements LambdaLabel.VisitorP<Boolean> {
    private Graphics g;
    private FontMetrics fm;
    private Point point;

    public void draw(Graphics graphics, LambdaLabel lambdaLabel) {
        this.g = graphics;
        this.fm = graphics.getFontMetrics();
        LambdaLabelMetrics.getWidth(graphics, lambdaLabel);
        this.point = new Point(0, this.fm.getAscent() + this.fm.getLeading());
        graphics.setColor(Color.BLACK);
        lambdaLabel.accept(this, false);
    }

    public void draw(Graphics graphics, LambdaLabel lambdaLabel, int n) {
        this.g = graphics;
        this.fm = graphics.getFontMetrics();
        LambdaLabelMetrics.getWidth(graphics, lambdaLabel);
        this.point = new Point(0, (n - this.fm.getHeight()) / 2 + this.fm.getAscent() + this.fm.getLeading());
        graphics.setColor(Color.BLACK);
        lambdaLabel.accept(this, false);
    }

    public void draw(Graphics graphics, LambdaLabel lambdaLabel, int n, int n2, int n3) {
        this.g = graphics;
        this.fm = graphics.getFontMetrics();
        LambdaLabelMetrics.getWidth(graphics, lambdaLabel);
        this.point = new Point(n, n2 + (n3 - this.fm.getHeight()) / 2 + this.fm.getAscent() + this.fm.getLeading());
        graphics.setColor(Color.BLACK);
        lambdaLabel.accept(this, false);
    }

    @Override
    public void visit(LambdaLabel.LiteralLabel literalLabel, Boolean bl) {
        String string = literalLabel.name;
        if (bl.booleanValue()) {
            this.drawString("(");
        }
        this.drawString(string);
        if (bl.booleanValue()) {
            this.drawString(")");
        }
    }

    @Override
    public void visit(LambdaLabel.ApplyLabel applyLabel, Boolean bl) {
        boolean bl2 = applyLabel.lexpr.isParenRequiredInAppLeft();
        boolean bl3 = applyLabel.rexpr.isParenRequiredInAppRight();
        if (bl.booleanValue()) {
            this.drawString("(");
        }
        applyLabel.lexpr.accept(this, bl2);
        applyLabel.rexpr.accept(this, bl3);
        if (bl.booleanValue()) {
            this.drawString(")");
        }
    }

    @Override
    public void visit(LambdaLabel.AbstractLabel abstractLabel, Boolean bl) {
        LambdaLabel lambdaLabel = abstractLabel;
        String string = "\\";
        while (lambdaLabel.isAbstract()) {
            LambdaLabel.AbstractLabel abstractLabel2 = lambdaLabel;
            string = string + abstractLabel2.name;
            lambdaLabel = abstractLabel2.body;
        }
        string = string + ".";
        if (bl.booleanValue()) {
            this.drawString("(");
        }
        this.drawString(string);
        lambdaLabel.accept(this, false);
        if (bl.booleanValue()) {
            this.drawString(")");
        }
    }

    @Override
    public void visit(LambdaLabel.MacroLabel macroLabel, Boolean bl) {
        String string = "<" + macroLabel.name + ">";
        if (bl.booleanValue()) {
            this.drawString("(");
        }
        this.drawString(string);
        if (bl.booleanValue()) {
            this.drawString(")");
        }
    }

    @Override
    public void visit(LambdaLabel.RedexWrapper redexWrapper, Boolean bl) {
        this.g.setColor(redexWrapper.color);
        int n = this.fm.getHeight();
        this.g.fillRoundRect(this.point.x + 1, this.point.y - (this.fm.getAscent() + this.fm.getLeading()) + 1, redexWrapper.getWidth() - 2, this.fm.getHeight() - 2, n, n);
        this.g.setColor(Color.BLACK);
        this.point.x += 2;
        redexWrapper.lambda.accept(this, bl);
        this.point.x += 2;
    }

    private void drawString(String string) {
        this.g.drawString(string, this.point.x, this.point.y - this.fm.getLeading());
        this.point.x += this.fm.stringWidth(string);
    }
}

