/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import extgui.LineEditor;
import extgui.flatsplitpane.FlatSplitPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lambda.Environment;
import lambda.LaTeXStringBuilder;
import lambda.LambdaInterpreter;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.ast.MacroExpander;
import lambda.ast.VariableCollector;
import lambda.ast.parser.ParserException;
import lambda.conversion.Converter;
import lambda.gui.MainMenu;
import lambda.gui.RedexView;
import lambda.gui.SimpleTextDialog;
import lambda.gui.macroview.MacroDefinitionView;
import lambda.gui.util.GUIUtils;
import lambda.macro.MacroDefinition;
import lambda.reduction.RedexFinder;
import lambda.reduction.Reducer;
import lambda.reduction.ReductionRule;
import lambda.stategraph.gui.StateGraphView;
import lambda.system.CommandDelegate;
import lambda.system.CommandProcessor;
import util.nullable.NullableBool;
import util.nullable.NullableInt;

public class MainFrame
extends JFrame {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("[HH:mm:ss]");
    private JTabbedPane tabbedPane;
    private LineEditor inputField;
    private JButton buttonStep;
    private JCheckBox checkPrintStep;
    private JCheckBox checkShort;
    private JCheckBox checkEtaEnabled;
    private JCheckBox checkDataConv;
    private JCheckBox checkAuto;
    private JCheckBox checkTraceInAuto;
    private JCheckBox checkPrintBetaEta;
    private JSpinner spinnerMaxSteps;
    private JButton buttonResume;
    private JButton buttonLaTeX;
    private JButton buttonStop;
    private JButton buttonClear;
    private RedexView redexView;
    private JTextArea output;
    private JTextArea systemOutput;
    private MacroDefinitionView macroView;
    private Environment env = Environment.getEnvironment();
    private MacroDefinition macros = new MacroDefinition();
    private final CommandProcessor commands = new CommandProcessor();
    private final LambdaInterpreter interpreter = new LambdaInterpreter();
    private boolean autoRunning;
    private AutoRunningThread thread;

    public MainFrame() {
        this.setTitle("Lambda * Magica 3.80");
        this.setJMenuBar(new MainMenu(this));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.inputField = new LineEditor();
        this.inputField.setFont(this.env.getGUIFont());
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.processInput();
            }
        });
        jPanel2.add((Component)this.inputField, "Center");
        this.buttonStep = new JButton("step");
        this.buttonStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.processInput();
            }
        });
        jPanel2.add((Component)this.buttonStep, "East");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        this.output = new JTextArea();
        this.output.setEditable(false);
        this.output.setFont(this.env.getGUIFont());
        this.systemOutput = new JTextArea();
        this.systemOutput.setEditable(false);
        this.systemOutput.setFont(this.env.getGUIFont());
        final FlatSplitPane flatSplitPane = new FlatSplitPane(0, true);
        flatSplitPane.setTopComponent(new JScrollPane(this.output));
        flatSplitPane.setBottomComponent(new JScrollPane(this.systemOutput));
        jPanel.add((Component)flatSplitPane, "Center");
        JPanel jPanel4 = this.createAutoModeConfigurationPanel();
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setBorder(BorderFactory.createTitledBorder("Reduction"));
        this.checkEtaEnabled = this.createOptionCheckBox("eta_reduction", "enable eta-reduction");
        jPanel5.add(this.checkEtaEnabled);
        jPanel3.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setBorder(BorderFactory.createTitledBorder("Printing"));
        this.checkPrintStep = this.createOptionCheckBox("print_step", "print step");
        this.checkPrintBetaEta = this.createOptionCheckBox("print_beta_eta", "print beta/eta");
        this.checkShort = this.createOptionCheckBox("short", "short printing");
        this.checkDataConv = this.createOptionCheckBox("data_abstraction", "show nat/bool data");
        jPanel6.add(this.checkPrintStep);
        jPanel6.add(this.checkPrintBetaEta);
        jPanel6.add(this.checkShort);
        jPanel6.add(this.checkDataConv);
        jPanel3.add(jPanel6);
        this.buttonLaTeX = new JButton("generate LaTeX source");
        this.buttonLaTeX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.generateLaTeX();
            }
        });
        jPanel3.add(this.buttonLaTeX);
        this.buttonClear = new JButton("clear output");
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.output.setText("");
            }
        });
        jPanel3.add(this.buttonClear);
        JButton jButton = new JButton("clear macros");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.clearMacros();
            }
        });
        jPanel3.add(jButton);
        GUIUtils.setVerticalLayout(jPanel3);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("General", jPanel3);
        this.redexView = new RedexView();
        this.redexView.setBackground(Color.WHITE);
        this.redexView.setFont(this.env.getGUIFont());
        this.redexView.setMargin(5, 5, 5, 5);
        this.redexView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.stepNormal();
            }
        });
        this.tabbedPane.add("Redex", new JScrollPane(this.redexView));
        this.macroView = new MacroDefinitionView();
        this.macroView.setFont(this.env.getGUIFont());
        this.tabbedPane.addTab("Macros", this.macroView);
        final StateGraphView stateGraphView = new StateGraphView();
        stateGraphView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = MainFrame.this.inputField.getText().trim();
                if (!string.isEmpty()) {
                    MainFrame.this.output.setText("");
                    MainFrame.this.inputField.saveHistory();
                    MainFrame.this.inputField.setText("");
                    try {
                        Lambda lambda = Lambda.parse(string);
                        MacroExpander macroExpander = new MacroExpander(MainFrame.this.macros);
                        lambda = macroExpander.expand(lambda, true);
                        stateGraphView.startSearch(lambda);
                    }
                    catch (ParserException parserException) {
                        parserException.printStackTrace();
                    }
                }
            }
        });
        this.tabbedPane.addTab("StateGraph", stateGraphView);
        final FlatSplitPane flatSplitPane2 = new FlatSplitPane();
        flatSplitPane2.setContinuousLayout(true);
        flatSplitPane2.setLeftComponent(jPanel);
        flatSplitPane2.setRightComponent(this.tabbedPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                flatSplitPane2.setDividerLocation(0.7);
                flatSplitPane2.setResizeWeight(0.5);
                flatSplitPane.setDividerLocation(0.8);
                flatSplitPane.setResizeWeight(0.9);
            }
        });
        flatSplitPane2.setDividerLocation(Short.MAX_VALUE);
        this.add(flatSplitPane2);
        this.setSize(700, 600);
        this.setupAcceleration();
        this.initializeCommands();
    }

    private JPanel createAutoModeConfigurationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Auto Mode"));
        this.checkAuto = this.createOptionCheckBox("auto", "auto reduction");
        this.checkAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.updateAutoModePanel();
            }
        });
        this.checkTraceInAuto = this.createOptionCheckBox("trace", "show trace in auto mode");
        JPanel jPanel2 = new JPanel();
        this.spinnerMaxSteps = new JSpinner(new SpinnerNumberModel(this.env.getInt("continue_steps", 100), 0, 1000, 1));
        this.spinnerMaxSteps.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MainFrame.this.env.set("continue_steps", MainFrame.this.spinnerMaxSteps.getValue());
            }
        });
        jPanel2.add(new JLabel("step limit:"));
        jPanel2.add(this.spinnerMaxSteps);
        GUIUtils.setHorizontalLayout(jPanel2, true, true);
        this.buttonResume = new JButton("continue");
        this.buttonResume.setEnabled(false);
        this.buttonResume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.autoRunning && MainFrame.this.thread != null) {
                    MainFrame.this.thread.resumeAuto();
                }
            }
        });
        this.buttonStop = new JButton("stop");
        this.buttonStop.setEnabled(false);
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.autoRunning && MainFrame.this.thread != null) {
                    MainFrame.this.stopAuto();
                }
            }
        });
        jPanel.add(this.checkAuto);
        jPanel.add(this.checkTraceInAuto);
        jPanel.add(jPanel2);
        jPanel.add(this.buttonResume);
        jPanel.add(this.buttonStop);
        GUIUtils.setVerticalLayout(jPanel);
        this.updateAutoModePanel();
        return jPanel;
    }

    private void updateAutoModePanel() {
        boolean bl = this.checkAuto.isSelected();
        this.checkTraceInAuto.setEnabled(bl);
        this.spinnerMaxSteps.setEnabled(bl);
    }

    private void setupAcceleration() {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        String string = "font.size.increase";
        String string2 = "font.size.decrease";
        String string3 = "font.size.default";
        String string4 = "revert";
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(521, n), string);
        inputMap.put(KeyStroke.getKeyStroke(107, n), string);
        inputMap.put(KeyStroke.getKeyStroke(59, n), string);
        inputMap.put(KeyStroke.getKeyStroke(45, n), string2);
        inputMap.put(KeyStroke.getKeyStroke(109, n), string2);
        inputMap.put(KeyStroke.getKeyStroke(48, n), string3);
        inputMap.put(KeyStroke.getKeyStroke(10, 64), string4);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(string, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Environment environment = Environment.getEnvironment();
                int n = environment.getInt("gui.fontsize", 12);
                if (n < 120) {
                    environment.set("gui.fontsize", n + 1);
                    MainFrame.this.setCodeFont(environment.getGUIFont());
                }
            }
        });
        actionMap.put(string2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Environment environment = Environment.getEnvironment();
                int n = environment.getInt("gui.fontsize", 12);
                if (5 < n) {
                    environment.set("gui.fontsize", n - 1);
                    MainFrame.this.setCodeFont(environment.getGUIFont());
                }
            }
        });
        actionMap.put(string3, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Environment environment = Environment.getEnvironment();
                environment.set("gui.fontsize", 12);
                MainFrame.this.setCodeFont(environment.getGUIFont());
            }
        });
        actionMap.put(string4, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MainFrame.this.autoRunning) {
                    MainFrame.this.stepBackward();
                }
            }
        });
    }

    private JCheckBox createOptionCheckBox(final String string, String string2) {
        final JCheckBox jCheckBox = new JCheckBox(string2);
        jCheckBox.setSelected(this.env.getBoolean(string));
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.env.set(string, jCheckBox.isSelected());
            }
        });
        return jCheckBox;
    }

    public void setCodeFont(Font font) {
        this.inputField.setFont(font);
        this.output.setFont(font);
        this.systemOutput.setFont(font);
        this.redexView.setFont(font);
        this.macroView.setFont(font);
    }

    private void processInput() {
        String string = this.inputField.getText().trim();
        if (!string.isEmpty()) {
            this.output.setText("");
            this.inputField.saveHistory();
            this.inputField.setText("");
            this.start(string);
        } else {
            this.stepNormal();
        }
    }

    private void start(String string) {
        if (this.autoRunning) {
            return;
        }
        if ((string = string.trim()).startsWith(":")) {
            String[] stringArray;
            String[] stringArray2 = string.split("\\s+");
            String string2 = stringArray2[0];
            if (!this.commands.invokeCommand(string2, stringArray = Arrays.copyOfRange(stringArray2, 1, stringArray2.length))) {
                this.println("- unknown command " + string2);
            }
        } else if (!string.isEmpty()) {
            try {
                this.evalLine(string);
            }
            catch (ParserException parserException) {
                String string3 = "";
                for (int i = 0; i < parserException.column; ++i) {
                    string3 = string3 + ' ';
                }
                this.println(string);
                this.println(string3 + '^');
                this.println("- " + parserException.getMessage());
            }
        }
    }

    private IRedexNode getDefaultRedex() {
        boolean bl = this.env.getBoolean("eta_reduction");
        return RedexFinder.getLeftMostOuterMostRedex(this.interpreter.getLambda(), bl);
    }

    private IRedexNode getSelectedRedex() {
        IRedexNode iRedexNode = this.redexView.getSelectedRedex();
        return iRedexNode != null ? iRedexNode : this.getDefaultRedex();
    }

    private boolean stepReduction(boolean bl) {
        IRedexNode iRedexNode;
        if (this.interpreter.isTerminated()) {
            return false;
        }
        IRedexNode iRedexNode2 = iRedexNode = bl ? this.getDefaultRedex() : this.getSelectedRedex();
        if (iRedexNode == null) {
            return false;
        }
        boolean bl2 = true;
        Reducer.Result result = this.interpreter.step(this.macros, iRedexNode);
        if (result.reduced) {
            if (!bl || this.env.getBoolean("trace")) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.env.getBoolean("print_step")) {
                    if (result.appliedRule == ReductionRule.MACRO_EXPANSION) {
                        stringBuilder.append("  -: ");
                    } else {
                        stringBuilder.append(String.format("%3d: ", this.interpreter.getReductionStepCount()));
                    }
                }
                if (this.env.getBoolean("print_beta_eta")) {
                    switch (result.appliedRule) {
                        case BETA_REDUCTION: {
                            stringBuilder.append("\u03b2");
                            break;
                        }
                        case ETA_REDUCTION: {
                            stringBuilder.append("\u03b7");
                            break;
                        }
                        case MACRO_EXPANSION: {
                            stringBuilder.append(" ");
                            break;
                        }
                    }
                }
                switch (result.appliedRule) {
                    case BETA_REDUCTION: 
                    case ETA_REDUCTION: {
                        stringBuilder.append(" --> ");
                        break;
                    }
                    case MACRO_EXPANSION: {
                        stringBuilder.append("   = ");
                        break;
                    }
                }
                String string = this.interpreter.getLambda().toString();
                if (this.env.getBoolean("short") && string.length() > 75) {
                    stringBuilder.append(string.substring(0, 35));
                    stringBuilder.append(" ... ");
                    stringBuilder.append(string.substring(string.length() - 35, string.length()));
                } else {
                    stringBuilder.append(string);
                }
                this.println(stringBuilder.toString());
            }
            if (this.checkIfCycled() || this.checkIfNormalForm()) {
                this.reductionTerminated();
                bl2 = false;
            }
        } else {
            this.reductionTerminated();
            bl2 = false;
        }
        return bl2;
    }

    private boolean stepNormal() {
        boolean bl = this.stepReduction(false);
        this.updateRedexView(this.interpreter.getLambda());
        return bl;
    }

    private synchronized boolean stepAuto() {
        return this.stepReduction(true);
    }

    private void stepBackward() {
        if (!this.autoRunning && !this.interpreter.isTerminated() && this.interpreter.isRevertable()) {
            this.interpreter.revert();
            this.deleteLine();
            this.updateRedexView(this.interpreter.getLambda());
        }
    }

    private void showConvertedData(Lambda lambda) {
        NullableBool nullableBool;
        NullableInt nullableInt = Converter.toNat(lambda);
        if (nullableInt.hasValue()) {
            this.println("  = " + nullableInt + " (as nat)");
        }
        if ((nullableBool = Converter.toBool(lambda)).hasValue()) {
            this.println("  = " + nullableBool + " (as bool)");
        }
    }

    private boolean checkIfNormalForm() {
        boolean bl;
        Lambda lambda = this.interpreter.getLambda();
        if (RedexFinder.isNormalForm(lambda, bl = this.env.getBoolean("eta_reduction"))) {
            this.printEndState(lambda, "(normal form)");
            return true;
        }
        return false;
    }

    private boolean checkIfCycled() {
        if (this.interpreter.isCyclic()) {
            this.printEndState(this.interpreter.getLambda(), "(cyclic reduction)");
            return true;
        }
        return false;
    }

    private void printEndState(Lambda lambda, String string) {
        MacroExpander macroExpander = new MacroExpander(this.macros);
        lambda = macroExpander.expand(lambda, true);
        this.println("==> " + lambda + "    " + string);
        if (this.env.getBoolean("data_abstraction")) {
            this.showConvertedData(lambda);
        }
    }

    private void reductionTerminated() {
        this.buttonStop.setEnabled(false);
    }

    private void updateRedexView(Lambda lambda) {
        this.redexView.setRedexes(lambda);
        this.redexView.revalidate();
        this.redexView.repaint();
    }

    private void defineMacro(String string, String string2) {
        try {
            Lambda lambda = Lambda.parse(string2);
            this.macros.defineMacro(string, lambda);
            this.macroView.addMacro(string, lambda);
            this.println(String.format("- <%s> is defined as %s", string, lambda));
            VariableCollector variableCollector = new VariableCollector(lambda);
            Set<String> set = variableCollector.getFreeVariables();
            if (!set.isEmpty()) {
                this.println(String.format("- Warning: <%s> contains free variables %s", string, set));
            }
        }
        catch (ParserException parserException) {
            this.println("- " + parserException.getMessage());
        }
    }

    private void readMacro(String string) {
        if (string.indexOf(61) != -1) {
            String[] stringArray = string.split("\\s*=\\s*");
            if (stringArray.length == 2) {
                this.defineMacro(stringArray[0], stringArray[1]);
            } else {
                this.println("- Invalid expression: " + string);
            }
        }
    }

    private void evalLine(String string) throws ParserException {
        if (string.indexOf(61) != -1) {
            this.readMacro(string);
        } else {
            Lambda lambda = Lambda.parse(string);
            this.println(lambda.toString());
            this.interpreter.startInterpretation(lambda);
            if (this.checkIfNormalForm()) {
                this.reductionTerminated();
            } else if (!this.env.getBoolean("auto")) {
                this.tabbedPane.setSelectedIndex(1);
                this.buttonStep.requestFocus();
                this.updateRedexView(lambda);
            } else {
                this.startAuto();
            }
        }
    }

    private void startAuto() {
        this.autoRunning = true;
        this.buttonStop.setEnabled(true);
        this.buttonStep.setEnabled(false);
        this.thread = new AutoRunningThread();
        this.thread.start();
    }

    private void stopAuto() {
        if (this.thread != null) {
            this.interpreter.terminate();
            this.autoRunning = false;
            this.thread.resumeAuto();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.printSystemMessage("Stopped.");
        }
    }

    private void loadFile(String string) {
        if (!string.endsWith(".lm.txt")) {
            string = string + ".lm.txt";
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            this.println("- load '" + string + "'");
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(35);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                if ((string2 = string2.trim()).isEmpty()) continue;
                this.readMacro(string2);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.println("- cannot open file \"" + string + "\"");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void clearMacros() {
        this.macros.clearMacros();
        this.macroView.clearList();
        this.println("- macros were cleared.");
    }

    private void initializeCommands() {
        this.commands.add(":q", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                MainFrame.this.dispose();
            }
        });
        this.commands.add(":l", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                if (stringArray.length == 0) {
                    File file = new File(".");
                    for (File file2 : file.listFiles()) {
                        if (!file2.isFile() || !file2.getName().endsWith(".lm.txt")) continue;
                        MainFrame.this.loadFile(file2.getName());
                    }
                } else {
                    for (String string : stringArray) {
                        MainFrame.this.loadFile(string);
                    }
                }
            }
        });
        this.commands.add(":f", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                if (stringArray.length >= 1) {
                    String string = "";
                    for (String string2 : stringArray) {
                        string = string + string2 + " ";
                    }
                    try {
                        Lambda parserException = Lambda.parse(string);
                        MacroExpander macroExpander = new MacroExpander(MainFrame.this.macros);
                        MainFrame.this.println(macroExpander.expand(parserException, true).toString());
                    }
                    catch (ParserException parserException) {
                        MainFrame.this.println(parserException.getMessage());
                    }
                }
            }
        });
        this.commands.add(":c", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                MainFrame.this.clearMacros();
            }
        });
        this.commands.add(":pwd", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                MainFrame.this.println(new File("").getAbsolutePath());
            }
        });
        this.commands.add(":?", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                MainFrame.this.println("- :?         - show this help.");
                MainFrame.this.println("- :f <expr>  - expand all macros and show expression.");
                MainFrame.this.println("- :l <path>  - load lines from a text file.");
                MainFrame.this.println("- :c         - clear all macros.");
                MainFrame.this.println("- :pwd       - print working directory.");
                MainFrame.this.println("- :q         - quit interpreter.");
            }
        });
    }

    private void generateLaTeX() {
        StringBuilder stringBuilder = new StringBuilder();
        LaTeXStringBuilder laTeXStringBuilder = new LaTeXStringBuilder();
        stringBuilder.append("\\begin{eqnarray*}\n");
        for (LambdaInterpreter.State state : this.interpreter.getStates()) {
            switch (state.appliedRule) {
                case NONE: {
                    stringBuilder.append("&& ");
                    break;
                }
                case BETA_REDUCTION: {
                    stringBuilder.append("&\\longrightarrow_\\beta& ");
                    break;
                }
                case ETA_REDUCTION: {
                    stringBuilder.append("&\\longrightarrow_\\eta& ");
                    break;
                }
                case MACRO_EXPANSION: {
                    stringBuilder.append("&=& ");
                }
            }
            stringBuilder.append(laTeXStringBuilder.build(state.lambda, state.getReducedRedex()));
            stringBuilder.append(" \\\\\n");
        }
        stringBuilder.append("\\end{eqnarray*}\n");
        SimpleTextDialog simpleTextDialog = new SimpleTextDialog();
        simpleTextDialog.setTextAreaFont(this.output.getFont());
        simpleTextDialog.setText(stringBuilder.toString());
        simpleTextDialog.setVisible(true);
    }

    private synchronized void println(String string) {
        this.output.append(string);
        this.output.append(System.getProperty("line.separator"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.output.setCaretPosition(MainFrame.this.output.getText().length());
            }
        });
    }

    private synchronized void printSystemMessage(String string) {
        String string2 = DATE_FORMAT.format(new Date()) + " " + string;
        this.systemOutput.append(string2);
        this.systemOutput.append("\n");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.systemOutput.setCaretPosition(MainFrame.this.systemOutput.getText().length());
            }
        });
    }

    private synchronized void deleteLine() {
        String string = this.output.getText().trim();
        int n = string.lastIndexOf(10);
        if (n != -1) {
            string = string.substring(0, n + 1);
            this.output.setText(string);
        }
    }

    private class AutoRunningThread
    extends Thread {
        private int nextLimit;
        private boolean noLimit;
        private boolean suspended;

        public AutoRunningThread() {
            this.setName("AutoRunningThread");
            this.setDaemon(true);
            this.updateLimit();
        }

        public synchronized void resumeAuto() {
            MainFrame.this.printSystemMessage("Resumed.");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.buttonResume.setEnabled(false);
                }
            });
            this.updateLimit();
            this.suspended = false;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (MainFrame.this.autoRunning) {
                    if (!MainFrame.this.stepAuto()) {
                        break;
                    }
                    if (!this.isLimited()) continue;
                    MainFrame.this.printSystemMessage(MainFrame.this.interpreter.getReductionStepCount() + " steps done. Continue?");
                    this.suspendAuto();
                }
            }
            catch (StackOverflowError stackOverflowError) {
                MainFrame.this.println("Fatal Error: generated too large structure");
            }
            finally {
                this.finalizeAuto();
            }
        }

        private void updateLimit() {
            int n = MainFrame.this.env.getInt("continue_steps", 100);
            if (this.noLimit) {
                if (n >= 0) {
                    this.nextLimit = MainFrame.this.interpreter.getReductionStepCount() + n;
                    this.noLimit = false;
                }
            } else if (n == 0) {
                this.noLimit = true;
            } else {
                this.nextLimit += n;
            }
        }

        private boolean isLimited() {
            return !this.noLimit && MainFrame.this.interpreter.getReductionStepCount() >= this.nextLimit;
        }

        private synchronized void suspendAuto() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.buttonResume.setEnabled(true);
                }
            });
            this.suspended = true;
            try {
                while (this.suspended) {
                    this.notifyAll();
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }

        private void finalizeAuto() {
            MainFrame.this.autoRunning = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.buttonResume.setEnabled(false);
                    MainFrame.this.buttonStop.setEnabled(false);
                    MainFrame.this.buttonStep.setEnabled(true);
                }
            });
            MainFrame.this.thread = null;
        }
    }
}

