/*
 * Decompiled with CFR 0.152.
 */
package lambda.stategraph;

import java.util.Collections;
import java.util.List;
import lambda.ast.IRedexNode;
import lambda.ast.Lambda;
import lambda.reduction.RedexFinder;
import lambda.serialize.LambdaSerializer;
import lambda.stategraph.IStateNode;

public class LambdaNode
implements IStateNode {
    public final int depth;
    public final Lambda lambda;
    private String text;
    private short[] data;
    private List<IRedexNode> redexes;

    public LambdaNode(int n, Lambda lambda) {
        this.depth = n;
        this.lambda = lambda;
        this.data = LambdaSerializer.serialize(lambda);
        this.redexes = RedexFinder.getRedexList(lambda);
    }

    public short[] getData() {
        return this.data;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = this.lambda.toString().replace("\\", "\u03bb");
        }
        return this.text;
    }

    public List<IRedexNode> getRedexes() {
        return Collections.unmodifiableList(this.redexes);
    }

    @Override
    public boolean isNormalForm() {
        return this.redexes.isEmpty();
    }

    public int hashCode() {
        return 31 * this.data.length ^ this.data[0] ^ this.data[this.data.length >> 1];
    }

    private boolean equals(LambdaNode lambdaNode) {
        if (this.data.length != lambdaNode.data.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == lambdaNode.data[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof LambdaNode && this.equals((LambdaNode)object);
    }

    public String toString() {
        return this.lambda.toString();
    }
}

